/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.presentation.PreferencePresentationModel;
import fi.smaa.jsmaa.gui.views.CardinalPreferencesView;
import fi.smaa.jsmaa.gui.views.DefaultScaleRenderer;
import fi.smaa.jsmaa.gui.views.OrdinalPreferencesView;
import fi.smaa.jsmaa.gui.views.ScaleRenderer;
import fi.smaa.jsmaa.model.CardinalPreferenceInformation;
import fi.smaa.jsmaa.model.OrdinalPreferenceInformation;
import fi.smaa.jsmaa.model.SMAAModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.drugis.common.gui.ViewBuilder;

public class PreferenceInformationView
implements ViewBuilder {
    private PreferencePresentationModel model;
    private JComponent prefPanel;
    private ScaleRenderer renderer;

    public PreferenceInformationView(PreferencePresentationModel model) {
        this.model = model;
        this.renderer = new DefaultScaleRenderer();
    }

    public PreferenceInformationView(PreferencePresentationModel model, ScaleRenderer renderer) {
        this.model = model;
        this.renderer = renderer;
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref:grow", "p, 3dlu, p");
        int fullWidth = 3;
        AbstractValueModel preferenceTypeModel = this.model.getModel("preferenceType");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder());
        CellConstraints cc = new CellConstraints();
        PreferencePresentationModel.PreferenceType[] valueList = null;
        valueList = this.model.includesCardinalPreferences() ? PreferencePresentationModel.PreferenceType.values() : new PreferencePresentationModel.PreferenceType[]{PreferencePresentationModel.PreferenceType.MISSING, PreferencePresentationModel.PreferenceType.ORDINAL};
        SelectionInList<PreferencePresentationModel.PreferenceType> typeSelInList = new SelectionInList<PreferencePresentationModel.PreferenceType>(valueList, (ValueModel)preferenceTypeModel);
        JComboBox preferenceTypeBox = BasicComponentFactory.createComboBox(typeSelInList);
        builder.add((Component)preferenceTypeBox, cc.xy(1, 1));
        builder.addLabel("Preference information", cc.xyw(3, 1, fullWidth - 2));
        this.prefPanel = null;
        if (this.model.getPreferenceType() == PreferencePresentationModel.PreferenceType.ORDINAL) {
            SMAAModel smodel = (SMAAModel)this.model.getBean();
            OrdinalPreferencesView oview = new OrdinalPreferencesView((OrdinalPreferenceInformation)smodel.getPreferenceInformation());
            oview.setScaleRenderer(this.renderer);
            this.prefPanel = oview.buildPanel();
        } else if (this.model.getPreferenceType() == PreferencePresentationModel.PreferenceType.CARDINAL) {
            CardinalPreferencesView oview = new CardinalPreferencesView((CardinalPreferenceInformation)((SMAAModel)this.model.getBean()).getPreferenceInformation());
            oview.setScaleRenderer(this.renderer);
            this.prefPanel = oview.buildPanel();
        }
        if (this.prefPanel != null) {
            builder.add((Component)this.prefPanel, cc.xyw(1, 3, fullWidth));
        }
        preferenceTypeBox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PreferenceInformationView.this.prefPanel != null) {
                    PreferenceInformationView.this.prefPanel.requestFocusInWindow();
                }
            }
        });
        return builder.getPanel();
    }
}

