/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.IntervalFormat;
import fi.smaa.jsmaa.gui.components.MeasurementPanel;
import fi.smaa.jsmaa.gui.jfreechart.UtilityFunctionDataset;
import fi.smaa.jsmaa.gui.presentation.ImpactMatrixPresentationModel;
import fi.smaa.jsmaa.gui.presentation.OrdinalCriterionMeasurementsPM;
import fi.smaa.jsmaa.gui.views.CardinalCriterionMeasurementsView;
import fi.smaa.jsmaa.gui.views.OrdinalCriterionMeasurementsView;
import fi.smaa.jsmaa.gui.views.ProfilesView;
import fi.smaa.jsmaa.model.CardinalCriterion;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAATRIModel;
import fi.smaa.jsmaa.model.ScaleCriterion;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.drugis.common.gui.LayoutUtil;
import org.drugis.common.gui.ViewBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

public class CriterionView
implements ViewBuilder {
    protected Criterion criterion;
    protected SMAAModel model;

    public CriterionView(Criterion crit, SMAAModel model) {
        this.criterion = crit;
        this.model = model;
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("pref:grow:fill", "p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder());
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.buildOverviewPart(), cc.xy(1, 1));
        int row = 3;
        if (this.criterion instanceof OutrankingCriterion) {
            LayoutUtil.addRow(layout);
            builder.addSeparator("Thresholds", cc.xy(1, 3));
            LayoutUtil.addRow(layout);
            builder.add((Component)this.buildThresholdsPart(), cc.xy(1, 5));
            row = 7;
        }
        builder.addSeparator("Measurements", cc.xy(1, row));
        JComponent measPanel = null;
        if (this.criterion instanceof CardinalCriterion) {
            ImpactMatrixPresentationModel iModel = new ImpactMatrixPresentationModel(this.model.getImpactMatrix());
            measPanel = new CardinalCriterionMeasurementsView((CardinalCriterion)this.criterion, iModel).buildPanel();
        } else if (this.criterion instanceof OrdinalCriterion) {
            OrdinalCriterionMeasurementsPM pm = new OrdinalCriterionMeasurementsPM((OrdinalCriterion)this.criterion, this.model.getImpactMatrix());
            measPanel = new OrdinalCriterionMeasurementsView(pm).buildPanel();
        }
        builder.add(measPanel, cc.xy(1, row + 2));
        row += 4;
        if (this.criterion instanceof ScaleCriterion) {
            LayoutUtil.addRow(layout);
            builder.addSeparator("Value function", cc.xy(1, row));
            LayoutUtil.addRow(layout);
            JFreeChart chart = ChartFactory.createXYLineChart("", "x", "v(x)", new UtilityFunctionDataset((ScaleCriterion)this.criterion), PlotOrientation.VERTICAL, true, true, false);
            chart.removeLegend();
            ChartPanel chartPanel = new ChartPanel(chart);
            builder.add((Component)chartPanel, cc.xy(1, row + 2));
            row += 4;
        }
        if (this.model instanceof SMAATRIModel) {
            LayoutUtil.addRow(layout);
            builder.addSeparator("Profiles (category boundaries)", cc.xy(1, row));
            LayoutUtil.addRow(layout);
            builder.add((Component)new ProfilesView((OutrankingCriterion)this.criterion, (SMAATRIModel)this.model).buildPanel(), cc.xy(1, row + 2));
        }
        return builder.getPanel();
    }

    private JComponent buildOverviewPart() {
        PresentationModel<ScaleCriterion> pmc;
        CardinalCriterion cardCrit;
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        PresentationModel<Criterion> pm = new PresentationModel<Criterion>(this.criterion);
        builder.addLabel("Name:", cc.xy(1, 1));
        builder.add((Component)BasicComponentFactory.createLabel(pm.getModel("name")), cc.xy(3, 1));
        builder.addLabel("Type:", cc.xy(1, 3));
        builder.add((Component)BasicComponentFactory.createLabel(pm.getModel("typeLabel")), cc.xy(3, 3));
        int row = 5;
        if (this.criterion instanceof ScaleCriterion) {
            LayoutUtil.addRow(layout);
            cardCrit = (ScaleCriterion)this.criterion;
            pmc = new PresentationModel<ScaleCriterion>((ScaleCriterion)cardCrit);
            builder.addLabel("Scale:", cc.xy(1, row));
            builder.add((Component)BasicComponentFactory.createLabel(pmc.getModel("scale"), new IntervalFormat()), cc.xy(3, row));
            row += 2;
        }
        if (this.criterion instanceof CardinalCriterion) {
            cardCrit = (CardinalCriterion)this.criterion;
            pmc = new PresentationModel<ScaleCriterion>((ScaleCriterion)cardCrit);
            LayoutUtil.addRow(layout);
            builder.addLabel("Ascending:", cc.xy(1, row));
            builder.add((Component)BasicComponentFactory.createCheckBox(pmc.getModel("ascending"), null), cc.xy(3, row));
        }
        return builder.getPanel();
    }

    private JComponent buildThresholdsPart() {
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        final OutrankingCriterion outrCrit = (OutrankingCriterion)this.criterion;
        ValueHolder indifHolder = new ValueHolder(outrCrit.getIndifMeasurement());
        indifHolder.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                outrCrit.setIndifMeasurement((CardinalMeasurement)evt.getNewValue());
            }
        });
        ValueHolder prefHolder = new ValueHolder(outrCrit.getPrefMeasurement());
        prefHolder.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                outrCrit.setPrefMeasurement((CardinalMeasurement)evt.getNewValue());
            }
        });
        MeasurementPanel.MeasurementType[] measVals = new MeasurementPanel.MeasurementType[]{MeasurementPanel.MeasurementType.EXACT, MeasurementPanel.MeasurementType.INTERVAL, MeasurementPanel.MeasurementType.GAUSSIAN};
        MeasurementPanel indifPanel = new MeasurementPanel(indifHolder, measVals, null);
        MeasurementPanel prefPanel = new MeasurementPanel(prefHolder, measVals, null);
        builder.addLabel("Indifference:", cc.xy(1, 1));
        builder.add((Component)indifPanel, cc.xy(3, 1));
        builder.addLabel("Preference:", cc.xy(1, 3));
        builder.add((Component)prefPanel, cc.xy(3, 3));
        return builder.getPanel();
    }
}

