/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.IntervalFormat;
import fi.smaa.jsmaa.model.CardinalCriterion;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.ScaleCriterion;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.drugis.common.gui.LayoutUtil;
import org.drugis.common.gui.ViewBuilder;

public class CriteriaListView
implements ViewBuilder {
    private SMAAModel model;

    public CriteriaListView(SMAAModel model) {
        this.model = model;
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("pref, 3dlu, left:pref", "p");
        if (this.hasCardinalCriteria(this.model)) {
            layout.appendColumn(ColumnSpec.decode("3dlu"));
            layout.appendColumn(ColumnSpec.decode("center:pref"));
        }
        if (this.hasScaleCriteria(this.model)) {
            layout.appendColumn(ColumnSpec.decode("3dlu"));
            layout.appendColumn(ColumnSpec.decode("center:pref"));
        }
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder());
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Name", cc.xy(1, 1));
        builder.addLabel("Type", cc.xy(3, 1));
        if (this.hasCardinalCriteria(this.model)) {
            builder.addLabel("Ascending", cc.xy(5, 1));
        }
        if (this.hasScaleCriteria(this.model)) {
            builder.addLabel("Scale", cc.xy(7, 1));
        }
        int row = 3;
        for (Criterion c : this.model.getCriteria()) {
            PresentationModel<CardinalCriterion> cpm;
            CardinalCriterion cardCrit;
            LayoutUtil.addRow(layout);
            PresentationModel<Criterion> pm = new PresentationModel<Criterion>(c);
            builder.add((Component)BasicComponentFactory.createLabel(pm.getModel("name")), cc.xy(1, row));
            builder.add((Component)BasicComponentFactory.createLabel(pm.getModel("typeLabel")), cc.xy(3, row));
            if (c instanceof CardinalCriterion) {
                cardCrit = (CardinalCriterion)c;
                cpm = new PresentationModel<CardinalCriterion>(cardCrit);
                builder.add((Component)BasicComponentFactory.createCheckBox(cpm.getModel("ascending"), null), cc.xy(5, row));
            }
            if (c instanceof ScaleCriterion) {
                cardCrit = (ScaleCriterion)c;
                cpm = new PresentationModel<CardinalCriterion>(cardCrit);
                builder.add((Component)BasicComponentFactory.createLabel(cpm.getModel("scale"), new IntervalFormat()), cc.xy(7, row));
            }
            row += 2;
        }
        return builder.getPanel();
    }

    private boolean hasScaleCriteria(SMAAModel model2) {
        for (Criterion c : this.model.getCriteria()) {
            if (!(c instanceof ScaleCriterion)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCardinalCriteria(SMAAModel model) {
        for (Criterion c : model.getCriteria()) {
            if (!(c instanceof CardinalCriterion)) continue;
            return true;
        }
        return false;
    }
}

