/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.value.ValueHolder;
import fi.smaa.jsmaa.gui.components.MeasurementPanel;
import fi.smaa.jsmaa.gui.views.AbstractPreferencesView;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.CardinalPreferenceInformation;
import fi.smaa.jsmaa.model.Criterion;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardinalPreferencesView
extends AbstractPreferencesView<CardinalPreferenceInformation> {
    private Map<Criterion, ValueHolder> values;

    public CardinalPreferencesView(CardinalPreferenceInformation pref) {
        super(pref);
        this.initValueHolders();
    }

    private void initValueHolders() {
        this.values = new HashMap<Criterion, ValueHolder>();
        for (Criterion c : ((CardinalPreferenceInformation)this.prefs).getCriteria()) {
            ValueHolder holder = new ValueHolder(((CardinalPreferenceInformation)this.prefs).getMeasurement(c));
            this.values.put(c, holder);
            holder.addPropertyChangeListener(new HolderListener(c));
        }
    }

    @Override
    protected JComponent getPreferenceComponent(Criterion c, int i) {
        MeasurementPanel.MeasurementType[] mvals = new MeasurementPanel.MeasurementType[]{MeasurementPanel.MeasurementType.EXACT, MeasurementPanel.MeasurementType.INTERVAL};
        ValueHolder holder = this.values.get(c);
        MeasurementPanel vpanel = new MeasurementPanel(holder, mvals, null);
        return vpanel;
    }

    @Override
    protected String getTypeName() {
        return "Weight constraint";
    }

    private class HolderListener
    implements PropertyChangeListener {
        private Criterion c;

        public HolderListener(Criterion c) {
            this.c = c;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ((CardinalPreferenceInformation)CardinalPreferencesView.this.prefs).setMeasurement(this.c, (CardinalMeasurement)evt.getNewValue());
        }
    }
}

