/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.components.MeasurementPanel;
import fi.smaa.jsmaa.gui.presentation.ImpactMatrixPresentationModel;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.CardinalCriterion;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ImpactMatrix;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.drugis.common.gui.LayoutUtil;
import org.drugis.common.gui.ViewBuilder;

public class CardinalCriterionMeasurementsView
implements ViewBuilder {
    private Criterion criterion;
    private ImpactMatrixPresentationModel model;

    public CardinalCriterionMeasurementsView(CardinalCriterion c, ImpactMatrixPresentationModel model) {
        this.model = model;
        this.criterion = c;
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref", "p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder());
        CellConstraints cc = new CellConstraints();
        for (int i = 0; i < this.model.getAlternatives().size(); ++i) {
            Alternative a = this.model.getAlternatives().get(i);
            int row = 1 + i * 2;
            if (i != 0) {
                LayoutUtil.addRow(layout);
            }
            builder.add((Component)BasicComponentFactory.createLabel(new PresentationModel<Alternative>(a).getModel("name")), cc.xy(1, row));
            MeasurementPanel comp = null;
            if (this.criterion instanceof CardinalCriterion) {
                comp = new MeasurementPanel(this.model.getMeasurementHolder(a, this.criterion), ((ImpactMatrix)this.model.getBean()).getBaseline(this.criterion));
            } else if (this.criterion instanceof OrdinalCriterion) {
                // empty if block
            }
            builder.add(comp, cc.xy(3, row));
        }
        return builder.getPanel();
    }
}

