/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.components.FocusTransferrer;
import fi.smaa.jsmaa.gui.views.DefaultScaleRenderer;
import fi.smaa.jsmaa.gui.views.ScaleRenderer;
import fi.smaa.jsmaa.model.AbstractPreferenceInformation;
import fi.smaa.jsmaa.model.Criterion;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.drugis.common.gui.LayoutUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreferencesView<T extends AbstractPreferenceInformation<?>> {
    protected T prefs;
    private ScaleRenderer scaleRenderer = new DefaultScaleRenderer();

    public AbstractPreferencesView(T prefs) {
        this.prefs = prefs;
    }

    public void setScaleRenderer(ScaleRenderer renderer) {
        this.scaleRenderer = renderer;
    }

    protected abstract JComponent getPreferenceComponent(Criterion var1, int var2);

    protected abstract String getTypeName();

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("right:pref, 7dlu, center:pref, 3dlu, center:pref", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Criterion", cc.xy(1, 1));
        builder.addLabel("Scale", cc.xy(3, 1));
        builder.addLabel(this.getTypeName(), cc.xy(5, 1));
        int row = 3;
        int i = 0;
        JComponent firstComp = null;
        for (Criterion c : ((AbstractPreferenceInformation)this.prefs).getCriteria()) {
            LayoutUtil.addRow(layout);
            JLabel label = new JLabel();
            Bindings.bind(label, "text", new PresentationModel<Criterion>(c).getModel("name"));
            builder.add((Component)label, cc.xy(1, row += 2));
            builder.add((Component)this.scaleRenderer.getScaleComponent(c), cc.xy(3, row));
            JComponent measurementComp = this.getPreferenceComponent(c, i);
            builder.add((Component)measurementComp, cc.xy(5, row));
            if (firstComp == null) {
                firstComp = measurementComp;
            }
            ++i;
        }
        JPanel panel = builder.getPanel();
        if (firstComp != null) {
            panel.addFocusListener(new FocusTransferrer(firstComp));
        }
        return panel;
    }
}

