/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.presentation;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.value.AbstractValueModel;
import fi.smaa.jsmaa.model.CardinalPreferenceInformation;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.MissingPreferenceInformation;
import fi.smaa.jsmaa.model.OrdinalPreferenceInformation;
import fi.smaa.jsmaa.model.SMAAModel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencePresentationModel
extends PresentationModel<SMAAModel> {
    public static final String PREFERENCE_TYPE = "preferenceType";
    private OrdinalPreferenceInformation ordinalPreferences;
    private CardinalPreferenceInformation cardinalPreferences;
    private boolean includeCardinal;

    public PreferencePresentationModel(SMAAModel model, boolean includeCardinal) {
        super(model);
        this.includeCardinal = includeCardinal;
    }

    public boolean includesCardinalPreferences() {
        return this.includeCardinal;
    }

    @Override
    public AbstractValueModel getModel(String property) {
        if (property.equals(PREFERENCE_TYPE)) {
            return new PreferenceTypeValueModel();
        }
        return super.getModel(property);
    }

    public void setPreferenceType(PreferenceType preferenceType) {
        PreferenceType oldVal = this.getPreferenceType();
        if (preferenceType == PreferenceType.CARDINAL) {
            ((SMAAModel)this.getBean()).setPreferenceInformation(this.generateCardinalPreferences());
        } else if (preferenceType == PreferenceType.ORDINAL) {
            ((SMAAModel)this.getBean()).setPreferenceInformation(this.generateOrdinalPreferences());
        } else if (preferenceType == PreferenceType.MISSING) {
            ((SMAAModel)this.getBean()).setPreferenceInformation(this.generateMissingPreferences());
        } else {
            throw new RuntimeException("unknown preference type");
        }
        this.firePropertyChange(PREFERENCE_TYPE, (Object)oldVal, (Object)preferenceType);
    }

    private CardinalPreferenceInformation generateCardinalPreferences() {
        if (this.cardinalPreferences == null) {
            this.cardinalPreferences = new CardinalPreferenceInformation(((SMAAModel)this.getBean()).getCriteria());
        }
        return this.cardinalPreferences;
    }

    private OrdinalPreferenceInformation generateOrdinalPreferences() {
        if (this.ordinalPreferences == null) {
            List<Criterion> crit = ((SMAAModel)this.getBean()).getCriteria();
            this.ordinalPreferences = new OrdinalPreferenceInformation(crit);
        }
        return this.ordinalPreferences;
    }

    private MissingPreferenceInformation generateMissingPreferences() {
        return new MissingPreferenceInformation(((SMAAModel)this.getBean()).getCriteria().size());
    }

    public PreferenceType getPreferenceType() {
        if (((SMAAModel)this.getBean()).getPreferenceInformation() instanceof MissingPreferenceInformation) {
            return PreferenceType.MISSING;
        }
        if (((SMAAModel)this.getBean()).getPreferenceInformation() instanceof CardinalPreferenceInformation) {
            return PreferenceType.CARDINAL;
        }
        if (((SMAAModel)this.getBean()).getPreferenceInformation() instanceof OrdinalPreferenceInformation) {
            return PreferenceType.ORDINAL;
        }
        throw new RuntimeException("unknown preference type");
    }

    public class PreferenceTypeValueModel
    extends AbstractValueModel {
        public Object getValue() {
            return PreferencePresentationModel.this.getPreferenceType();
        }

        public void setValue(Object val) {
            PreferenceType oldVal = PreferencePresentationModel.this.getPreferenceType();
            PreferencePresentationModel.this.setPreferenceType((PreferenceType)((Object)val));
            this.fireValueChange((Object)oldVal, val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreferenceType {
        MISSING("Missing"),
        ORDINAL("Ordinal"),
        CARDINAL("Cardinal");

        private String label;

        private PreferenceType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

