/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.presentation;

import fi.smaa.jsmaa.gui.presentation.LeftTreeModel;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.ModelChangeEvent;
import fi.smaa.jsmaa.model.SMAAModelListener;
import fi.smaa.jsmaa.model.SMAATRIModel;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class LeftTreeModelSMAATRI
extends LeftTreeModel {
    private static int CATEGORIES = 2;
    private static int PREFERENCES = 3;
    private static int RESULTS = 4;
    private String categoriesNode = "Categories";
    private String categoryAcceptabilitiesNode = "CatAcc";

    public LeftTreeModelSMAATRI(SMAATRIModel smaaModel) throws NullPointerException {
        super(smaaModel);
        smaaModel.addModelListener(new SMAAModelListener(){

            @Override
            public void modelChanged(ModelChangeEvent ev) {
                if (ev.getType() == 7) {
                    LeftTreeModelSMAATRI.this.fireTreeChange();
                }
            }
        });
    }

    public Object getCategoriesNode() {
        return this.categoriesNode;
    }

    public Object getCatAccNode() {
        return this.categoryAcceptabilitiesNode;
    }

    public TreePath getPathForCategory(Alternative cat) {
        return new TreePath(new Object[]{this.smaaModel, this.categoriesNode, cat});
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.getRoot()) {
            if (index == RESULTS) {
                return this.resultsNode;
            }
            if (index == CATEGORIES) {
                return this.categoriesNode;
            }
            if (index == PREFERENCES) {
                return this.preferencesNode;
            }
        } else {
            if (parent == this.categoriesNode) {
                return ((SMAATRIModel)this.smaaModel).getCategories().get(index);
            }
            if (parent == this.resultsNode) {
                return this.categoryAcceptabilitiesNode;
            }
        }
        return super.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return 5;
        }
        if (parent == this.categoriesNode) {
            return ((SMAATRIModel)this.smaaModel).getCategories().size();
        }
        if (parent == this.resultsNode) {
            return 1;
        }
        return super.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Alternative && ((SMAATRIModel)this.smaaModel).getCategories().contains(node)) {
            return true;
        }
        if (node == this.categoryAcceptabilitiesNode) {
            return true;
        }
        return super.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof Alternative && ((SMAATRIModel)this.smaaModel).getCategories().contains(obj)) {
            ((Alternative)obj).setName((String)newValue);
            return;
        }
        super.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.categoriesNode) {
            int index;
            if (child instanceof Alternative && (index = new ArrayList<Alternative>(((SMAATRIModel)this.smaaModel).getCategories()).indexOf(child)) != -1) {
                return index;
            }
        } else if (parent == this.getRoot()) {
            if (child == this.categoriesNode) {
                return CATEGORIES;
            }
            if (child == this.resultsNode) {
                return RESULTS;
            }
            if (child == this.preferencesNode) {
                return PREFERENCES;
            }
        } else if (parent == this.getResultsNode() && child == this.categoryAcceptabilitiesNode) {
            return 0;
        }
        return super.getIndexOfChild(parent, child);
    }
}

