/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.presentation;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ModelChangeEvent;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAAModelListener;
import fi.smaa.jsmaa.model.ScaleCriterion;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LeftTreeModel
implements TreeModel {
    private ArrayList<TreeModelListener> treeModelListeners = new ArrayList();
    protected SMAAModel smaaModel;
    private static final int ALTERNATIVES = 0;
    private static final int CRITERIA = 1;
    private static final int PREFERENCES = 2;
    private static final int RESULTS = 3;
    protected String alternativesNode = "Alternatives";
    protected String criteriaNode = "Criteria";
    protected String resultsNode = "Results";
    protected String rankAccNode = "RankAcc";
    protected String centralWeightsNode = "CW";
    protected String preferencesNode = "Preferences";

    public LeftTreeModel(SMAAModel smaaModel) throws NullPointerException {
        if (smaaModel == null) {
            throw new NullPointerException();
        }
        this.smaaModel = smaaModel;
        smaaModel.addModelListener(new SMAAModelListener(){

            @Override
            public void modelChanged(ModelChangeEvent ev) {
                if (ev.getType() == 2 || ev.getType() == 1) {
                    LeftTreeModel.this.fireTreeChange();
                }
            }
        });
    }

    public void setSMAAModel(SMAAModel model) {
        this.smaaModel = model;
        this.fireTreeChange();
    }

    public Object getModelNode() {
        return this.smaaModel;
    }

    public Object getAlternativesNode() {
        return this.alternativesNode;
    }

    public Object getCriteriaNode() {
        return this.criteriaNode;
    }

    public Object getResultsNode() {
        return this.resultsNode;
    }

    public Object getCentralWeightsNode() {
        return this.centralWeightsNode;
    }

    public Object getRankAcceptabilitiesNode() {
        return this.rankAccNode;
    }

    public Object getPreferencesNode() {
        return this.preferencesNode;
    }

    public TreePath getPathForAlternative(Alternative alt) {
        return new TreePath(new Object[]{this.smaaModel, this.alternativesNode, alt});
    }

    public TreePath getPathForCriterion(Criterion c) {
        return new TreePath(new Object[]{this.smaaModel, this.criteriaNode, c});
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.getRoot()) {
            if (index == 0) {
                return this.alternativesNode;
            }
            if (index == 1) {
                return this.criteriaNode;
            }
            if (index == 3) {
                return this.resultsNode;
            }
            if (index == 2) {
                return this.preferencesNode;
            }
        } else {
            if (parent == this.alternativesNode) {
                return new ArrayList<Alternative>(this.smaaModel.getAlternatives()).get(index);
            }
            if (parent == this.criteriaNode) {
                return new ArrayList<Criterion>(this.smaaModel.getCriteria()).get(index);
            }
            if (parent == this.resultsNode) {
                if (index == 0) {
                    return this.rankAccNode;
                }
                if (index == 1) {
                    return this.centralWeightsNode;
                }
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return 4;
        }
        if (parent == this.alternativesNode) {
            return this.smaaModel.getAlternatives().size();
        }
        if (parent == this.criteriaNode) {
            return this.smaaModel.getCriteria().size();
        }
        if (parent == this.resultsNode) {
            return 2;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.getRoot()) {
            if (child == this.alternativesNode) {
                return 0;
            }
            if (child == this.criteriaNode) {
                return 1;
            }
            if (child == this.resultsNode) {
                return 3;
            }
            if (child == this.preferencesNode) {
                return 2;
            }
        } else if (parent == this.alternativesNode) {
            int index;
            if (child instanceof Alternative && (index = new ArrayList<Alternative>(this.smaaModel.getAlternatives()).indexOf(child)) != -1) {
                return index;
            }
        } else if (parent == this.criteriaNode) {
            int index;
            if (child instanceof Criterion && (index = new ArrayList<Criterion>(this.smaaModel.getCriteria()).indexOf(child)) != -1) {
                return index;
            }
        } else if (parent == this.resultsNode) {
            if (child == this.rankAccNode) {
                return 0;
            }
            if (child == this.centralWeightsNode) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.smaaModel;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Alternative) {
            if (this.smaaModel.getAlternatives().contains(node)) {
                return true;
            }
        } else if (node instanceof Criterion) {
            if (this.smaaModel.getCriteria().contains(node)) {
                return true;
            }
        } else {
            if (node == this.alternativesNode) {
                return false;
            }
            if (node == this.criteriaNode) {
                return false;
            }
            if (node == this.resultsNode) {
                return false;
            }
            if (node == this.rankAccNode) {
                return true;
            }
            if (node == this.centralWeightsNode) {
                return true;
            }
            if (node == this.preferencesNode) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (!this.treeModelListeners.contains(l)) {
            this.treeModelListeners.add(l);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof Alternative) {
            if (!this.smaaModel.getAlternatives().contains(new Alternative((String)newValue))) {
                ((Alternative)obj).setName((String)newValue);
            }
        } else if (obj instanceof Criterion) {
            if (!this.smaaModel.getCriteria().contains(new ScaleCriterion((String)newValue))) {
                ((Criterion)obj).setName((String)newValue);
            }
        } else if (obj instanceof SMAAModel) {
            ((SMAAModel)obj).setName((String)newValue);
        }
    }

    protected void fireTreeChange() {
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }
}

