/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.jfreechart;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.simulator.ResultsEvent;
import fi.smaa.jsmaa.simulator.SMAAResults;
import fi.smaa.jsmaa.simulator.SMAAResultsListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMAADataSet<R extends SMAAResults>
implements SMAAResultsListener,
Dataset {
    private List<DatasetChangeListener> dataListeners = new ArrayList<DatasetChangeListener>();
    private DatasetGroup group;
    protected R results;
    protected NameListener nameListener = new NameListener();

    protected SMAADataSet(R results) {
        this.setResults(results);
    }

    public synchronized void setResults(R results) {
        this.results = results;
        ((SMAAResults)results).addResultsListener(this);
        for (Alternative a : ((SMAAResults)results).getAlternatives()) {
            a.addPropertyChangeListener(this.nameListener);
        }
        this.fireResultsChanged();
    }

    @Override
    public synchronized void addChangeListener(DatasetChangeListener l) {
        this.dataListeners.add(l);
    }

    @Override
    public DatasetGroup getGroup() {
        return this.group;
    }

    @Override
    public synchronized void removeChangeListener(DatasetChangeListener l) {
        this.dataListeners.remove(l);
    }

    @Override
    public void setGroup(DatasetGroup g) {
        this.group = g;
    }

    @Override
    public void resultsChanged(ResultsEvent ev) {
        this.fireResultsChanged();
    }

    private synchronized void fireResultsChanged() {
        for (DatasetChangeListener l : this.dataListeners) {
            l.datasetChanged(new DatasetChangeEvent(this, this));
        }
    }

    private class NameListener
    implements PropertyChangeListener {
        private NameListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("name")) {
                SMAADataSet.this.fireResultsChanged();
            }
        }
    }
}

