/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.jfreechart;

import fi.smaa.jsmaa.gui.jfreechart.AlternativeColumnCategoryDataset;
import fi.smaa.jsmaa.simulator.SMAA2Results;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.UnknownKeyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankAcceptabilitiesDataset
extends AlternativeColumnCategoryDataset<SMAA2Results> {
    private List<Rank> ranks;

    public RankAcceptabilitiesDataset(SMAA2Results results) {
        super(results);
    }

    @Override
    public void setResults(SMAA2Results results) {
        this.ranks = new ArrayList<Rank>();
        for (int i = 0; i < results.getAlternatives().size(); ++i) {
            this.ranks.add(new Rank(i));
        }
        super.setResults(results);
    }

    @Override
    public int getRowIndex(Comparable rank) {
        return this.ranks.indexOf(rank);
    }

    @Override
    public Comparable getRowKey(int rankIndex) {
        if (rankIndex < 0 || rankIndex >= this.ranks.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ranks.get(rankIndex);
    }

    @Override
    public List getRowKeys() {
        return this.ranks;
    }

    @Override
    public Number getValue(Comparable rank, Comparable alt) {
        if (!this.ranks.contains(rank)) {
            throw new UnknownKeyException("unknown rank");
        }
        if (!((SMAA2Results)this.results).getAlternatives().contains(alt)) {
            throw new UnknownKeyException("unknown alt");
        }
        List<Double> accs = ((SMAA2Results)this.results).getRankAcceptabilities().get(alt);
        return accs.get(((Rank)rank).getIndex());
    }

    @Override
    public int getRowCount() {
        return this.ranks.size();
    }

    @Override
    public Number getValue(int rankIndex, int altIndex) {
        return this.getValue(new Rank(rankIndex), ((SMAA2Results)this.results).getAlternatives().get(altIndex));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rank
    implements Comparable<Rank> {
        private int index;

        public Rank(int index) {
            this.index = index;
        }

        public String toString() {
            return "Rank " + (this.index + 1);
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public int compareTo(Rank o) {
            return new Integer(this.index).compareTo(new Integer(o.getIndex()));
        }

        public boolean equals(Object other) {
            if (!(other instanceof Rank)) {
                return false;
            }
            Rank r = (Rank)other;
            return r.getIndex() == this.index;
        }
    }
}

