/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.jfreechart;

import fi.smaa.jsmaa.gui.jfreechart.AbstractPlotConverter;
import fi.smaa.jsmaa.gui.jfreechart.AlternativeColumnCategoryDataset;
import fi.smaa.jsmaa.gui.jfreechart.CentralWeightsDataset;
import fi.smaa.jsmaa.gui.jfreechart.PlotConverter;
import fi.smaa.jsmaa.gui.jfreechart.SMAADataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotConverterFactory {
    public static PlotConverter getConverter(SMAADataSet<?> s) {
        if (s instanceof CentralWeightsDataset) {
            return new CentralWeightsDatasetConverter((CentralWeightsDataset)s);
        }
        if (s instanceof AlternativeColumnCategoryDataset) {
            return new CategoryDatasetConverter((AlternativeColumnCategoryDataset)s);
        }
        throw new IllegalArgumentException("no plot converters available for " + s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryDatasetConverter
    extends AbstractPlotConverter<AlternativeColumnCategoryDataset<?>> {
        public CategoryDatasetConverter(AlternativeColumnCategoryDataset<?> dataset) {
            super(dataset);
        }

        @Override
        public String getScript() {
            String res = "set style data histograms\nset style fill solid 1.00 border -1\nset grid\nplot 'data.dat'";
            for (int i = 0; i < ((AlternativeColumnCategoryDataset)this.dataset).getRowCount(); ++i) {
                if (i != 0) {
                    res = res + "''";
                }
                res = res + " u " + (i + 2);
                if (i == ((AlternativeColumnCategoryDataset)this.dataset).getRowCount() - 1) {
                    res = res + ":xticlabels(1)";
                }
                res = res + " title columnhead";
                if (i >= ((AlternativeColumnCategoryDataset)this.dataset).getRowCount() - 1) continue;
                res = res + ", ";
            }
            res = res + "\npause -1";
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CentralWeightsDatasetConverter
    extends AbstractPlotConverter<CentralWeightsDataset> {
        public CentralWeightsDatasetConverter(CentralWeightsDataset s) {
            super(s);
        }

        @Override
        public String getScript() {
            String res = "set grid\nset xrange[0.9:" + ((CentralWeightsDataset)this.dataset).getColumnCount() + ".1]\n" + "plot 'data.dat'";
            for (int i = 0; i < ((CentralWeightsDataset)this.dataset).getRowCount(); ++i) {
                if (i != 0) {
                    res = res + "''";
                }
                res = res + " u " + (i + 2);
                if (i == ((CentralWeightsDataset)this.dataset).getRowCount() - 1) {
                    res = res + ":xticlabels(1)";
                }
                res = res + " with linespoints title \"" + ((CentralWeightsDataset)this.dataset).getRowKey(i) + "\"";
                if (i >= ((CentralWeightsDataset)this.dataset).getRowCount() - 1) continue;
                res = res + ", ";
            }
            res = res + "\npause -1";
            return res;
        }
    }
}

