/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.jfreechart;

import fi.smaa.jsmaa.gui.jfreechart.SMAADataSet;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.simulator.SMAA2Results;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralWeightsDataset
extends SMAADataSet<SMAA2Results>
implements CategoryDataset {
    public CentralWeightsDataset(SMAA2Results res) {
        super(res);
    }

    @Override
    public int getColumnIndex(Comparable crit) {
        return ((SMAA2Results)this.results).getCriteria().indexOf(crit);
    }

    @Override
    public Comparable getColumnKey(int critIndex) {
        if (critIndex < 0 || critIndex >= ((SMAA2Results)this.results).getCriteria().size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return ((SMAA2Results)this.results).getCriteria().get(critIndex);
    }

    @Override
    public List getColumnKeys() {
        return ((SMAA2Results)this.results).getCriteria();
    }

    @Override
    public int getRowIndex(Comparable alt) {
        return this.getAlternativesWithCentralWeights().indexOf(alt);
    }

    private List<Alternative> getAlternativesWithCentralWeights() {
        ArrayList<Alternative> alts = new ArrayList<Alternative>();
        for (Alternative a : ((SMAA2Results)this.results).getAlternatives()) {
            Map<Criterion, Double> cws = ((SMAA2Results)this.results).getCentralWeightVectors().get(a);
            Set<Map.Entry<Criterion, Double>> entrySet = cws.entrySet();
            if (entrySet.isEmpty() || entrySet.iterator().next().getValue().equals(Double.NaN)) continue;
            alts.add(a);
        }
        return alts;
    }

    @Override
    public Comparable getRowKey(int altIndex) {
        List<Alternative> alts = this.getAlternativesWithCentralWeights();
        if (altIndex < 0 || altIndex >= alts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return alts.get(altIndex);
    }

    @Override
    public List getRowKeys() {
        return this.getAlternativesWithCentralWeights();
    }

    @Override
    public Number getValue(Comparable alt, Comparable crit) {
        if (!this.getAlternativesWithCentralWeights().contains(alt)) {
            throw new UnknownKeyException("unknown alt");
        }
        if (!((SMAA2Results)this.results).getCriteria().contains(crit)) {
            throw new UnknownKeyException("unknown crit");
        }
        return ((SMAA2Results)this.results).getCentralWeightVectors().get(alt).get(crit);
    }

    @Override
    public int getColumnCount() {
        return ((SMAA2Results)this.results).getCriteria().size();
    }

    @Override
    public int getRowCount() {
        return this.getAlternativesWithCentralWeights().size();
    }

    @Override
    public Number getValue(int altIndex, int critIndex) {
        return this.getValue(this.getAlternativesWithCentralWeights().get(altIndex), ((SMAA2Results)this.results).getCriteria().get(critIndex));
    }
}

