/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.jfreechart;

import fi.smaa.jsmaa.gui.jfreechart.AlternativeColumnCategoryDataset;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.simulator.SMAATRIResults;
import java.util.List;
import org.jfree.data.UnknownKeyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryAcceptabilitiesDataset
extends AlternativeColumnCategoryDataset<SMAATRIResults> {
    public CategoryAcceptabilitiesDataset(SMAATRIResults results) {
        super(results);
        for (Alternative a : results.getCategories()) {
            a.addPropertyChangeListener(this.nameListener);
        }
    }

    @Override
    public int getRowIndex(Comparable cat) {
        return ((SMAATRIResults)this.results).getCategories().indexOf(cat);
    }

    @Override
    public Comparable getRowKey(int index) {
        if (index < 0 || index >= ((SMAATRIResults)this.results).getCategories().size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return ((SMAATRIResults)this.results).getCategories().get(index);
    }

    @Override
    public List getRowKeys() {
        return ((SMAATRIResults)this.results).getCategories();
    }

    @Override
    public Number getValue(Comparable cat, Comparable alt) {
        if (!((SMAATRIResults)this.results).getAlternatives().contains(alt)) {
            throw new UnknownKeyException("Unknown alternative");
        }
        if (!((SMAATRIResults)this.results).getCategories().contains(cat)) {
            throw new UnknownKeyException("Unknown category");
        }
        List<Double> accs = ((SMAATRIResults)this.results).getCategoryAcceptabilities().get(alt);
        int catIndex = ((SMAATRIResults)this.results).getCategories().indexOf(cat);
        if (catIndex < 0) {
            return Double.NaN;
        }
        return accs.get(catIndex);
    }

    @Override
    public int getRowCount() {
        return ((SMAATRIResults)this.results).getCategories().size();
    }

    @Override
    public Number getValue(int catIndex, int altIndex) {
        return this.getValue(((SMAATRIResults)this.results).getCategories().get(catIndex), ((SMAATRIResults)this.results).getAlternatives().get(altIndex));
    }
}

