/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ResultsCellRenderer
extends DefaultTableCellRenderer {
    protected Double maxValue;

    public ResultsCellRenderer(Double maxValue) {
        this.setHorizontalAlignment(0);
        this.maxValue = maxValue;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null || value instanceof Double && value.equals(Double.NaN)) {
            this.setValue("NA");
        } else if (value instanceof Double) {
            this.setDoubleValue((Double)value);
        } else {
            super.setValue(value);
        }
        if (isSelected) {
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        return this;
    }

    private void setDoubleValue(Double value) {
        DecimalFormat decFormat = new DecimalFormat("##0.00");
        this.setValue(decFormat.format(value));
    }
}

