/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.components;

import fi.smaa.jsmaa.gui.components.ResultsCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class ResultsCellColorRenderer
extends ResultsCellRenderer {
    public ResultsCellColorRenderer(Double maxValue) {
        super(maxValue);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null || value instanceof Double && value.equals(Double.NaN)) {
            this.setBackground(Color.white);
        } else if (value instanceof Double) {
            this.setDoubleColor((Double)value);
        } else {
            this.setBackground(Color.white);
        }
        return this;
    }

    protected void setDoubleColor(Double value) {
        Double share = value / this.maxValue;
        int red = 0;
        int green = 0;
        if (share < 0.5) {
            share = share * 2.0;
            green = (int)(255.0 * share);
            red = 255;
        } else {
            share = (share - 0.5) * 2.0;
            red = (int)(255.0 - share * 255.0);
            green = 255;
        }
        this.setBackground(new Color(red, green, 0));
    }
}

