/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.components;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import fi.smaa.jsmaa.gui.components.BetaMeasurementPanel;
import fi.smaa.jsmaa.gui.components.FocusTransferrer;
import fi.smaa.jsmaa.gui.components.GaussianMeasurementPanel;
import fi.smaa.jsmaa.gui.components.IntervalPanel;
import fi.smaa.jsmaa.gui.components.RelativMeasurementPanel;
import fi.smaa.jsmaa.model.BaselineGaussianMeasurement;
import fi.smaa.jsmaa.model.BetaMeasurement;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.ExactMeasurement;
import fi.smaa.jsmaa.model.GaussianMeasurement;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.LogNormalMeasurement;
import fi.smaa.jsmaa.model.LogitNormalMeasurement;
import fi.smaa.jsmaa.model.RelativeGaussianMeasurementBase;
import fi.smaa.jsmaa.model.RelativeLogitNormalMeasurement;
import fi.smaa.jsmaa.model.RelativeNormalMeasurement;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatter;

public class MeasurementPanel
extends JPanel {
    private ValueModel holder;
    private MeasurementType[] allowedValues;
    private JComponent valuePanel;
    private JComboBox chooserPanel;
    private JComboBox chooserComboBox;
    private BaselineGaussianMeasurement baselineMeasurement;

    public MeasurementPanel(ValueModel measurementHolder, BaselineGaussianMeasurement baseline) {
        this(measurementHolder, MeasurementType.values(), baseline);
    }

    public MeasurementPanel(ValueModel measurementHolder, MeasurementType[] allowedValues, BaselineGaussianMeasurement baseline) {
        this.allowedValues = allowedValues;
        this.holder = measurementHolder;
        this.baselineMeasurement = baseline;
        this.init();
        this.rebuildPanel();
    }

    public void init() {
        this.holder.addValueChangeListener(new HolderListener());
        this.setLayout(new FlowLayout(1, 5, 0));
        this.chooserPanel = this.buildChooserPanel();
        this.addFocusListener(new FocusTransferrer(this.chooserPanel));
    }

    public void rebuildPanel() {
        this.removeAll();
        this.valuePanel = this.buildValuePanel();
        this.add(this.chooserPanel);
        this.add(this.valuePanel);
        this.revalidate();
    }

    private JComboBox buildChooserPanel() {
        ChooserValueModel valueModel = new ChooserValueModel();
        SelectionInList<MeasurementType> selInList = new SelectionInList<MeasurementType>(this.allowedValues, (ValueModel)valueModel);
        this.chooserComboBox = new JComboBox();
        this.chooserComboBox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MeasurementPanel.this.valuePanel.requestFocusInWindow();
                MeasurementPanel.this.updateChooserTooltipText();
            }
        });
        this.updateChooserTooltipText();
        Bindings.bind(this.chooserComboBox, selInList);
        return this.chooserComboBox;
    }

    protected void updateChooserTooltipText() {
        String text = null;
        if (this.holder.getValue() instanceof Interval) {
            text = "Interval is input as [min, max]";
        } else if (this.holder.getValue() instanceof LogNormalMeasurement) {
            text = "Log-normal distributed measurement is input as ln(mean) \u00b1 ln(stdev)";
        } else if (this.holder.getValue() instanceof GaussianMeasurement) {
            text = "Gaussian distributed measurement is input as mean \u00b1 stdev";
        } else if (this.holder.getValue() instanceof BetaMeasurement) {
            text = "Beta distributed measurement is input as alpha, beta, min, max";
        }
        this.chooserComboBox.setToolTipText(text);
    }

    private JComponent buildValuePanel() {
        CardinalMeasurement m = (CardinalMeasurement)this.holder.getValue();
        JComponent measComp = null;
        if (m instanceof ExactMeasurement) {
            ExactMeasurement em = (ExactMeasurement)m;
            JFormattedTextField tf = BasicComponentFactory.createFormattedTextField((ValueModel)new PresentationModel<ExactMeasurement>(em).getModel("value"), new DefaultFormatter());
            tf.setHorizontalAlignment(0);
            tf.setColumns(10);
            measComp = tf;
        } else if (m instanceof Interval) {
            Interval ival = (Interval)m;
            measComp = new IntervalPanel(this, new PresentationModel<Interval>(ival));
        } else if (m instanceof GaussianMeasurement) {
            GaussianMeasurement gm = (GaussianMeasurement)m;
            measComp = new GaussianMeasurementPanel(this, new PresentationModel<GaussianMeasurement>(gm));
        } else if (m instanceof BetaMeasurement) {
            BetaMeasurement gm = (BetaMeasurement)m;
            measComp = new BetaMeasurementPanel(this, new PresentationModel<BetaMeasurement>(gm));
        } else if (m instanceof RelativeGaussianMeasurementBase) {
            RelativeGaussianMeasurementBase gm = (RelativeGaussianMeasurementBase)m;
            measComp = new RelativMeasurementPanel(this, gm);
        } else {
            throw new RuntimeException("unknown measurement type");
        }
        return measComp;
    }

    private class ChooserValueModel
    extends AbstractValueModel {
        private ChooserValueModel() {
        }

        public Object getValue() {
            CardinalMeasurement m = (CardinalMeasurement)MeasurementPanel.this.holder.getValue();
            if (m instanceof ExactMeasurement) {
                return MeasurementType.EXACT;
            }
            if (m instanceof Interval) {
                return MeasurementType.INTERVAL;
            }
            if (m instanceof LogNormalMeasurement) {
                return MeasurementType.LOGNORMAL;
            }
            if (m instanceof LogitNormalMeasurement) {
                return MeasurementType.LOGITNORMAL;
            }
            if (m instanceof RelativeLogitNormalMeasurement) {
                return MeasurementType.RELATIVELOGITNORMAL;
            }
            if (m instanceof RelativeNormalMeasurement) {
                return MeasurementType.RELATIVENORMAL;
            }
            if (m instanceof GaussianMeasurement) {
                return MeasurementType.GAUSSIAN;
            }
            if (m instanceof BetaMeasurement) {
                return MeasurementType.BETA;
            }
            throw new RuntimeException("unknown measurement type");
        }

        public void setValue(Object newValue) {
            MeasurementType type = (MeasurementType)((Object)newValue);
            Interval oldBounds = null;
            if (MeasurementPanel.this.holder.getValue() instanceof GaussianMeasurement) {
                Double mean = ((GaussianMeasurement)MeasurementPanel.this.holder.getValue()).getMean();
                oldBounds = new Interval(mean, mean);
            } else if (MeasurementPanel.this.holder.getValue() instanceof CardinalMeasurement) {
                oldBounds = ((CardinalMeasurement)MeasurementPanel.this.holder.getValue()).getRange();
            }
            if (type == MeasurementType.EXACT) {
                if (oldBounds != null) {
                    MeasurementPanel.this.holder.setValue(new ExactMeasurement(oldBounds.getMiddle()));
                } else {
                    MeasurementPanel.this.holder.setValue(new ExactMeasurement(0.0));
                }
            } else if (type == MeasurementType.INTERVAL) {
                if (oldBounds != null) {
                    MeasurementPanel.this.holder.setValue(oldBounds.deepCopy());
                } else {
                    MeasurementPanel.this.holder.setValue(new Interval(0.0, 1.0));
                }
            } else if (type == MeasurementType.LOGNORMAL) {
                if (oldBounds != null) {
                    MeasurementPanel.this.holder.setValue(new LogNormalMeasurement((double)oldBounds.getMiddle(), 0.0));
                } else {
                    MeasurementPanel.this.holder.setValue(new LogNormalMeasurement(0.0, 0.0));
                }
            } else if (type == MeasurementType.LOGITNORMAL) {
                if (oldBounds != null) {
                    MeasurementPanel.this.holder.setValue(new LogitNormalMeasurement((double)oldBounds.getMiddle(), 0.0));
                } else {
                    MeasurementPanel.this.holder.setValue(new LogitNormalMeasurement(0.0, 0.0));
                }
            } else if (type == MeasurementType.GAUSSIAN) {
                if (oldBounds != null) {
                    MeasurementPanel.this.holder.setValue(new GaussianMeasurement(oldBounds.getMiddle(), 0.0));
                } else {
                    MeasurementPanel.this.holder.setValue(new GaussianMeasurement(1.0, 0.0));
                }
            } else if (type == MeasurementType.RELATIVENORMAL) {
                MeasurementPanel.this.holder.setValue(new RelativeNormalMeasurement(MeasurementPanel.this.baselineMeasurement));
            } else if (type == MeasurementType.RELATIVELOGITNORMAL) {
                MeasurementPanel.this.holder.setValue(new RelativeLogitNormalMeasurement(MeasurementPanel.this.baselineMeasurement));
            } else if (type == MeasurementType.BETA) {
                MeasurementPanel.this.holder.setValue(new BetaMeasurement(2.0, 2.0, 0.0, 1.0));
            } else {
                throw new RuntimeException("unknown measurement type");
            }
        }
    }

    private class HolderListener
    implements PropertyChangeListener {
        private HolderListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MeasurementPanel.this.rebuildPanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MeasurementType {
        EXACT("Exact"),
        INTERVAL("Interval"),
        GAUSSIAN("Gaussian"),
        LOGNORMAL("LogNormal"),
        LOGITNORMAL("LogitNormal"),
        RELATIVENORMAL("RelativeNormal"),
        RELATIVELOGITNORMAL("RelativeLogit"),
        BETA("Beta");

        private String label;

        private MeasurementType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }
    }
}

