/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.components;

import com.jidesoft.swing.RangeSlider;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.SMAATRIModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LambdaPanel
extends JPanel {
    private RangeSlider lambdaSlider;
    private JLabel lambdaRangeLabel;
    private SMAATRIModel model;

    public LambdaPanel(SMAATRIModel model) {
        this.model = model;
        this.initComponents();
        model.getLambda().addPropertyChangeListener(new LambdaListener());
        this.updateLambdaSlider();
        this.updateLambdaLabel();
    }

    private void updateLambdaSlider() {
        this.lambdaSlider.setLowValue((int)(this.model.getLambda().getStart() * 100.0));
        this.lambdaSlider.setHighValue((int)(this.model.getLambda().getEnd() * 100.0));
    }

    private void initComponents() {
        this.lambdaSlider = new RangeSlider(50, 100, (int)(this.model.getLambda().getStart() * 100.0), (int)(this.model.getLambda().getEnd() * 100.0));
        this.lambdaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LambdaPanel.this.fireLambdaSliderChanged();
            }
        });
        this.lambdaRangeLabel = new JLabel();
        this.add((Component)this.lambdaSlider, "Center");
        this.add((Component)new JLabel("Lambda range"), "North");
        this.add((Component)this.lambdaRangeLabel, "South");
    }

    private void updateLambdaLabel() {
        this.lambdaRangeLabel.setText("[" + (double)this.lambdaSlider.getLowValue() / 100.0 + "-" + (double)this.lambdaSlider.getHighValue() / 100.0 + "]");
    }

    protected void fireLambdaSliderChanged() {
        Interval lambda = this.model.getLambda();
        double lowVal = (double)this.lambdaSlider.getLowValue() / 100.0;
        double highVal = (double)this.lambdaSlider.getHighValue() / 100.0;
        lambda.setStart(lowVal);
        lambda.setEnd(highVal);
    }

    private class LambdaListener
    implements PropertyChangeListener {
        private LambdaListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getNewValue().equals(evt.getOldValue())) {
                LambdaPanel.this.updateLambdaLabel();
                LambdaPanel.this.updateLambdaSlider();
            }
        }
    }
}

