/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class EnhancedTableHeader
extends JTableHeader {
    private static final int MAX_COL_WIDTH = 150;
    private final JTable d_table;

    public EnhancedTableHeader(TableColumnModel cm, JTable table) {
        super(cm);
        this.d_table = table;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                EnhancedTableHeader.this.doMouseClicked(e);
            }
        });
    }

    public static int getRequiredColumnWidth(JTable table, TableColumn column) {
        int modelIndex = column.getModelIndex();
        int requiredWidth = 0;
        int rows = table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TableCellRenderer renderer = table.getCellRenderer(i, modelIndex);
            Object valueAt = table.getValueAt(i, modelIndex);
            Component component = renderer.getTableCellRendererComponent(table, valueAt, false, false, i, modelIndex);
            requiredWidth = Math.max(requiredWidth, component.getPreferredSize().width + 25);
        }
        return requiredWidth;
    }

    public void autoSizeColumns() {
        EnhancedTableHeader.autoSizeColumns(this.d_table);
    }

    public static void autoSizeColumns(JTable table) {
        int col_count = table.getModel().getColumnCount();
        for (int i = 0; i < col_count; ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            int requiredColumnWidth = EnhancedTableHeader.getRequiredColumnWidth(table, col);
            if (requiredColumnWidth > 150) {
                requiredColumnWidth = 150;
            }
            col.setMinWidth(requiredColumnWidth);
        }
    }

    public void doMouseClicked(MouseEvent e) {
        if (!this.getResizingAllowed()) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        TableColumn column = this.getResizingColumn(e.getPoint(), this.columnAtPoint(e.getPoint()));
        if (column == null) {
            return;
        }
        int oldMinWidth = column.getMinWidth();
        column.setMinWidth(EnhancedTableHeader.getRequiredColumnWidth(this.d_table, column));
        this.setResizingColumn(column);
        this.d_table.doLayout();
        column.setMinWidth(oldMinWidth);
    }

    private TableColumn getResizingColumn(Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        Rectangle r = this.getHeaderRect(column);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.getColumnModel().getColumn(columnIndex);
    }
}

