/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.gui.AbstractGUIFactory;
import fi.smaa.jsmaa.gui.Focuser;
import fi.smaa.jsmaa.gui.MenuDirector;
import fi.smaa.jsmaa.gui.components.LambdaPanel;
import fi.smaa.jsmaa.gui.components.ResultsCellColorRenderer;
import fi.smaa.jsmaa.gui.components.ResultsTable;
import fi.smaa.jsmaa.gui.jfreechart.CategoryAcceptabilitiesDataset;
import fi.smaa.jsmaa.gui.presentation.CategoryAcceptabilityTableModel;
import fi.smaa.jsmaa.gui.presentation.LeftTreeModelSMAATRI;
import fi.smaa.jsmaa.gui.views.AlternativeInfoView;
import fi.smaa.jsmaa.gui.views.ResultsView;
import fi.smaa.jsmaa.gui.views.TechnicalParameterView;
import fi.smaa.jsmaa.gui.views.ViewWithHeader;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.ExactMeasurement;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.SMAATRIModel;
import fi.smaa.jsmaa.simulator.SMAATRIResults;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.drugis.common.ImageLoader;
import org.drugis.common.gui.ViewBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

public class SMAATRIGUIFactory
extends AbstractGUIFactory<LeftTreeModelSMAATRI, SMAATRIModel> {
    private CategoryAcceptabilityTableModel categoryAcceptabilityTM;
    private CategoryAcceptabilitiesDataset categoryAcceptabilityDataset;

    public SMAATRIGUIFactory(Window parent, SMAATRIModel smaaModel, MenuDirector director) {
        super(parent, smaaModel, director);
        SMAATRIResults emptyResults = new SMAATRIResults(Collections.EMPTY_LIST, Collections.EMPTY_LIST, 1);
        this.categoryAcceptabilityTM = new CategoryAcceptabilityTableModel(emptyResults);
        this.categoryAcceptabilityDataset = new CategoryAcceptabilitiesDataset(emptyResults);
    }

    public synchronized void setResults(SMAATRIResults results) {
        this.categoryAcceptabilityTM.setResults(results);
        this.categoryAcceptabilityDataset.setResults(results);
    }

    @Override
    protected LeftTreeModelSMAATRI buildTreeModel() {
        return new LeftTreeModelSMAATRI((SMAATRIModel)this.smaaModel);
    }

    @Override
    protected JToolBar buildBottomToolBar() {
        JToolBar tb = super.buildBottomToolBar();
        tb.add((Component)new LambdaPanel((SMAATRIModel)this.smaaModel), "East");
        return tb;
    }

    @Override
    protected JToolBar buildTopToolBar() {
        JToolBar bar = super.buildTopToolBar();
        JButton addCatButton = new JButton(ImageLoader.getIcon("add.gif"));
        addCatButton.setToolTipText("Add category");
        addCatButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMAATRIGUIFactory.this.addCategory();
            }
        });
        bar.add(addCatButton);
        return bar;
    }

    @Override
    public ViewBuilder buildView(Object o) {
        if (o instanceof Alternative && ((SMAATRIModel)this.smaaModel).getCategories().contains(o)) {
            return new ViewBuilder(){

                @Override
                public JComponent buildPanel() {
                    return new JPanel();
                }
            };
        }
        if (o == ((LeftTreeModelSMAATRI)this.treeModel).getModelNode()) {
            return new TechnicalParameterView((SMAATRIModel)this.smaaModel);
        }
        if (o == ((LeftTreeModelSMAATRI)this.treeModel).getCatAccNode()) {
            JFreeChart chart = ChartFactory.createStackedBarChart("", "Alternative", "Category Acceptability", this.categoryAcceptabilityDataset, PlotOrientation.VERTICAL, true, true, false);
            chart.getCategoryPlot().getRangeAxis().setUpperBound(1.0);
            ResultsTable table = new ResultsTable(this.categoryAcceptabilityTM);
            table.setAutoCreateRowSorter(true);
            table.setDefaultRenderer(Object.class, new ResultsCellColorRenderer(1.0));
            return new ViewWithHeader("Category acceptability indices", new ResultsView(this.parent, table, chart, "script.gif"));
        }
        if (o == ((LeftTreeModelSMAATRI)this.treeModel).getCategoriesNode()) {
            return new ViewWithHeader("Categories (in ascending order, top = worst)", new AlternativeInfoView(((SMAATRIModel)this.smaaModel).getCategories()));
        }
        return super.buildView(o);
    }

    @Override
    protected JMenuItem buildAddCriterionItem() {
        JMenuItem item = new JMenuItem("Add new");
        item.setIcon(ImageLoader.getIcon("add_criterion.gif"));
        item.addActionListener(new AddOutrankingCriterionAction());
        return item;
    }

    @Override
    protected JButton buildToolBarAddCriterionButton() {
        JButton button = new JButton(ImageLoader.getIcon("add_criterion.gif"));
        button.setToolTipText("Add criterion");
        button.addActionListener(new AddOutrankingCriterionAction());
        return button;
    }

    @Override
    protected List<JMenuItem> getEntityMenuList() {
        List<JMenuItem> list = super.getEntityMenuList();
        list.add(this.buildCategoryMenu());
        return list;
    }

    private JMenu buildCategoryMenu() {
        JMenu categoryMenu = new JMenu("Categories");
        categoryMenu.setMnemonic('t');
        JMenuItem showItem = new JMenuItem("Show");
        showItem.setMnemonic('s');
        JMenuItem addCatButton = this.createAddCatMenuItem();
        showItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Focuser.focus(SMAATRIGUIFactory.this.tree, SMAATRIGUIFactory.this.treeModel, ((LeftTreeModelSMAATRI)SMAATRIGUIFactory.this.treeModel).getCategoriesNode());
            }
        });
        categoryMenu.add(showItem);
        categoryMenu.addSeparator();
        categoryMenu.add(addCatButton);
        return categoryMenu;
    }

    private JMenuItem createAddCatMenuItem() {
        JMenuItem item = new JMenuItem("Add new");
        item.setMnemonic('n');
        item.setIcon(ImageLoader.getIcon("add.gif"));
        item.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMAATRIGUIFactory.this.addCategory();
            }
        });
        return item;
    }

    protected void addCategory() {
        List<Alternative> cats = ((SMAATRIModel)this.smaaModel).getCategories();
        int index = 1;
        while (true) {
            Alternative newCat = new Alternative("Category " + index);
            boolean found = false;
            for (Alternative cat : cats) {
                if (!cat.getName().equals(newCat.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                this.addCategoryAndStartRename(newCat);
                return;
            }
            ++index;
        }
    }

    @Override
    protected JMenu buildResultsMenu() {
        JMenu resultsMenu = new JMenu("Results");
        resultsMenu.setMnemonic('r');
        JMenuItem racsItem = new JMenuItem("Category acceptability indices", ImageLoader.getIcon("rankacceptabilities.gif"));
        racsItem.setMnemonic('r');
        racsItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Focuser.focus(SMAATRIGUIFactory.this.tree, SMAATRIGUIFactory.this.treeModel, ((LeftTreeModelSMAATRI)SMAATRIGUIFactory.this.treeModel).getCatAccNode());
            }
        });
        resultsMenu.add(racsItem);
        return resultsMenu;
    }

    private void addCategoryAndStartRename(Alternative a) {
        ((SMAATRIModel)this.smaaModel).addCategory(a);
        Focuser.focus(this.tree, this.treeModel, a);
        this.tree.startEditingAtPath(((LeftTreeModelSMAATRI)this.treeModel).getPathForCategory(a));
    }

    @Override
    protected void confirmDeleteAlternative(Alternative alternative) {
        if (!((SMAATRIModel)this.smaaModel).getCategories().contains(alternative)) {
            super.confirmDeleteAlternative(alternative);
        } else {
            String typeName = "category";
            int conf = JOptionPane.showConfirmDialog(this.parent, "Do you really want to delete " + typeName + " " + alternative + "?", "Confirm deletion", 0, 3, ImageLoader.getIcon("delete.gif"));
            if (conf == 0) {
                ((SMAATRIModel)this.smaaModel).deleteCategory(alternative);
            }
        }
    }

    private class AddOutrankingCriterionAction
    extends AbstractAction {
        private AddOutrankingCriterionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMAATRIGUIFactory.this.addCriterionAndStartRename(new OutrankingCriterion(SMAATRIGUIFactory.this.generateNextCriterionName(), true, new ExactMeasurement(0.0), new ExactMeasurement(1.0)));
        }
    }
}

