/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.gui.AbstractGUIFactory;
import fi.smaa.jsmaa.gui.Focuser;
import fi.smaa.jsmaa.gui.MenuDirector;
import fi.smaa.jsmaa.gui.components.CentralWeightsCellRenderer;
import fi.smaa.jsmaa.gui.components.ResultsCellColorRenderer;
import fi.smaa.jsmaa.gui.components.ResultsTable;
import fi.smaa.jsmaa.gui.jfreechart.CentralWeightsDataset;
import fi.smaa.jsmaa.gui.jfreechart.RankAcceptabilitiesDataset;
import fi.smaa.jsmaa.gui.presentation.CentralWeightTableModel;
import fi.smaa.jsmaa.gui.presentation.LeftTreeModel;
import fi.smaa.jsmaa.gui.presentation.RankAcceptabilityTableModel;
import fi.smaa.jsmaa.gui.views.ResultsView;
import fi.smaa.jsmaa.gui.views.ViewWithHeader;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.ScaleCriterion;
import fi.smaa.jsmaa.simulator.SMAA2Results;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.drugis.common.ImageLoader;
import org.drugis.common.gui.ViewBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;

public class SMAA2GUIFactory
extends AbstractGUIFactory<LeftTreeModel, SMAAModel> {
    private CentralWeightsDataset centralWeightsDataset;
    private CentralWeightTableModel centralWeightsTM;
    private RankAcceptabilitiesDataset rankAcceptabilitiesDataset;
    private RankAcceptabilityTableModel rankAcceptabilitiesTM;

    protected SMAA2GUIFactory(Window parent, SMAAModel smaaModel, MenuDirector director) {
        super(parent, smaaModel, director);
        SMAA2Results emptyResults = new SMAA2Results(Collections.EMPTY_LIST, Collections.EMPTY_LIST, 1);
        this.centralWeightsDataset = new CentralWeightsDataset(emptyResults);
        this.centralWeightsTM = new CentralWeightTableModel(emptyResults);
        this.rankAcceptabilitiesDataset = new RankAcceptabilitiesDataset(emptyResults);
        this.rankAcceptabilitiesTM = new RankAcceptabilityTableModel(emptyResults);
    }

    public synchronized void setResults(SMAA2Results results) {
        this.centralWeightsDataset.setResults(results);
        this.centralWeightsTM.setResults(results);
        this.rankAcceptabilitiesDataset.setResults(results);
        this.rankAcceptabilitiesTM.setResults(results);
    }

    @Override
    protected LeftTreeModel buildTreeModel() {
        return new LeftTreeModel(this.smaaModel);
    }

    @Override
    public ViewBuilder buildView(Object o) {
        if (o == this.treeModel.getCentralWeightsNode()) {
            JFreeChart chart = null;
            if (this.isChartDrawable()) {
                chart = ChartFactory.createLineChart("", "Criterion", "Central Weight", this.centralWeightsDataset, PlotOrientation.VERTICAL, true, true, false);
                LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, true);
                chart.getCategoryPlot().setRenderer(renderer);
            }
            ResultsTable table = new ResultsTable(this.centralWeightsTM);
            table.setAutoCreateRowSorter(true);
            table.setDefaultRenderer(Object.class, new CentralWeightsCellRenderer(1.0));
            table.getTableHeader().setToolTipText("CF = Confidence Factor");
            return new ViewWithHeader("Central weight vectors", new ResultsView(this.parent, table, chart, "script.gif"));
        }
        if (o == this.treeModel.getRankAcceptabilitiesNode()) {
            JFreeChart chart = null;
            if (this.isChartDrawable()) {
                chart = ChartFactory.createStackedBarChart("", "Alternative", "Rank Acceptability", this.rankAcceptabilitiesDataset, PlotOrientation.VERTICAL, true, true, false);
                chart.getCategoryPlot().getRangeAxis().setUpperBound(1.0);
            }
            ResultsTable table = new ResultsTable(this.rankAcceptabilitiesTM);
            table.setAutoCreateRowSorter(true);
            table.setDefaultRenderer(Object.class, new ResultsCellColorRenderer(1.0));
            table.getTableHeader().setToolTipText("Ranks in descending order, 1 is the best, 2 the second best, etc.");
            return new ViewWithHeader("Rank acceptability indices", new ResultsView(this.parent, table, chart, "script.gif"));
        }
        return super.buildView(o);
    }

    @Override
    protected JMenuItem buildAddCriterionItem() {
        JMenu menu = new JMenu("Add new");
        menu.setIcon(ImageLoader.getIcon("add_criterion.gif"));
        this.addUtilityAddItemsToMenu(menu);
        return menu;
    }

    @Override
    protected JButton buildToolBarAddCriterionButton() {
        JButton button = new JButton(ImageLoader.getIcon("add_criterion.gif"));
        button.setToolTipText("Add criterion");
        final JPopupMenu addMenu = new JPopupMenu();
        this.addUtilityAddItemsToMenu(addMenu);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                addMenu.show((Component)evt.getSource(), evt.getX(), evt.getY());
            }
        });
        return button;
    }

    private void addUtilityAddItemsToMenu(Container item) {
        JMenuItem cardCrit = this.createAddScaleCriterionItem();
        JMenuItem ordCrit = this.createAddOrdinalCriterionItem();
        item.add(cardCrit);
        item.add(ordCrit);
    }

    private JMenuItem createAddScaleCriterionItem() {
        JMenuItem cardCrit = new JMenuItem("Cardinal");
        cardCrit.setIcon(ImageLoader.getIcon("criterion_cardinal.gif"));
        cardCrit.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMAA2GUIFactory.this.addCriterionAndStartRename(new ScaleCriterion(SMAA2GUIFactory.this.generateNextCriterionName()));
            }
        });
        return cardCrit;
    }

    private JMenuItem createAddOrdinalCriterionItem() {
        JMenuItem ordCrit = new JMenuItem("Ordinal");
        ordCrit.setIcon(ImageLoader.getIcon("criterion_ordinal.gif"));
        ordCrit.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMAA2GUIFactory.this.addCriterionAndStartRename(new OrdinalCriterion(SMAA2GUIFactory.this.generateNextCriterionName()));
            }
        });
        return ordCrit;
    }

    @Override
    protected JMenu buildResultsMenu() {
        JMenu resultsMenu = new JMenu("Results");
        resultsMenu.setMnemonic('r');
        JMenuItem cwItem = new JMenuItem("Central weight vectors", ImageLoader.getIcon("centralweights.gif"));
        cwItem.setMnemonic('c');
        JMenuItem racsItem = new JMenuItem("Rank acceptability indices", ImageLoader.getIcon("rankacceptabilities.gif"));
        racsItem.setMnemonic('r');
        cwItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Focuser.focus(SMAA2GUIFactory.this.tree, SMAA2GUIFactory.this.treeModel, SMAA2GUIFactory.this.treeModel.getCentralWeightsNode());
            }
        });
        racsItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Focuser.focus(SMAA2GUIFactory.this.tree, SMAA2GUIFactory.this.treeModel, SMAA2GUIFactory.this.treeModel.getRankAcceptabilitiesNode());
            }
        });
        resultsMenu.add(cwItem);
        resultsMenu.add(racsItem);
        return resultsMenu;
    }
}

