/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import fi.smaa.jsmaa.model.Rank;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankSelectorGroup {
    private ArrayList<JComboBox> components = new ArrayList();
    private ListModel listModel;
    private List<Rank> boundRanks;

    public RankSelectorGroup(List<Rank> boundRanks) {
        int numBoxes = boundRanks.size();
        this.boundRanks = boundRanks;
        this.listModel = new ArrayListModel<Integer>(this.createObjects(numBoxes));
        this.createComponents();
    }

    private List<Integer> createObjects(int numBoxes) {
        ArrayList<Integer> ranks = new ArrayList<Integer>();
        for (int i = 1; i <= numBoxes; ++i) {
            ranks.add(i);
        }
        return ranks;
    }

    public List<JComboBox> getSelectors() {
        return this.components;
    }

    private void createComponents() {
        for (int i = 0; i < this.boundRanks.size(); ++i) {
            this.components.add(this.createComboBox(this.boundRanks.get(i)));
        }
    }

    private JComboBox createComboBox(Rank r) {
        PropertyAdapter<Rank> valueModel = new PropertyAdapter<Rank>(r, "rank", true);
        JComboBox chooser = new JComboBox(new ComboBoxAdapter(this.listModel, valueModel));
        chooser.setToolTipText("Rank in descending order, 1 is the best/most important, 2 the second, etc.");
        chooser.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RankSelectorGroup.this.comboBoxSelected((JComboBox)e.getSource());
            }
        });
        return chooser;
    }

    protected void comboBoxSelected(JComboBox source) {
        Integer selected = (Integer)source.getSelectedItem();
        JComboBox other = this.findSelecter(selected, source);
        if (other != null) {
            other.setSelectedItem(this.findUnselectedItem());
        }
    }

    private Integer findUnselectedItem() {
        for (int i = 1; i <= this.components.size(); ++i) {
            boolean found = false;
            for (JComboBox box : this.components) {
                if (!box.getSelectedItem().equals(new Integer(i))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return i;
        }
        return null;
    }

    private JComboBox findSelecter(Integer selected, JComboBox source) {
        for (JComboBox b : this.components) {
            if (b == source || b.getSelectedItem() != selected) continue;
            return b;
        }
        return null;
    }
}

