/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.gui.TransferableObject;
import fi.smaa.jsmaa.gui.presentation.LeftTreeModel;
import fi.smaa.jsmaa.gui.presentation.LeftTreeModelSMAATRI;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAATRIModel;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;

public class LeftTreeTransferHandler
extends TransferHandler {
    private LeftTreeModel model;
    private SMAAModel smaaModel;

    public LeftTreeTransferHandler(LeftTreeModel model, SMAAModel smaaModel) {
        this.model = model;
        this.smaaModel = smaaModel;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport ts) {
        if (!this.isLeftTree(ts.getComponent())) {
            return false;
        }
        if (!ts.isDrop()) {
            return false;
        }
        TransferHandler.DropLocation loc = ts.getDropLocation();
        if (loc instanceof JTree.DropLocation && this.isMovableNode((JTree.DropLocation)loc)) {
            try {
                Object o = ts.getTransferable().getTransferData(new DataFlavor(Object.class, ""));
                Object targetNode = ((JTree.DropLocation)loc).getPath().getLastPathComponent();
                if (o instanceof Criterion) {
                    return targetNode == this.model.getCriteriaNode();
                }
                if (o instanceof Alternative && this.smaaModel.getAlternatives().contains(o)) {
                    return targetNode == this.model.getAlternativesNode();
                }
                return targetNode == ((LeftTreeModelSMAATRI)this.model).getCategoriesNode();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean isMovableNode(JTree.DropLocation jdl) {
        Object lpc = jdl.getPath().getLastPathComponent();
        if (!lpc.equals(this.model.getCriteriaNode()) && !lpc.equals(this.model.getAlternativesNode())) {
            if (this.model instanceof LeftTreeModelSMAATRI) {
                if (!lpc.equals(((LeftTreeModelSMAATRI)this.model).getCategoriesNode())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return jdl.getChildIndex() >= 0;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (!this.isLeftTree(c)) {
            return null;
        }
        Object lastPathComponent = ((JTree)c).getSelectionPath().getLastPathComponent();
        if (!(lastPathComponent instanceof Criterion) && !(lastPathComponent instanceof Alternative)) {
            return null;
        }
        return new TransferableObject(lastPathComponent);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport t) {
        if (!t.isDrop()) {
            return false;
        }
        try {
            Object o = t.getTransferable().getTransferData(new DataFlavor(Object.class, ""));
            JTree.DropLocation jdl = (JTree.DropLocation)t.getDropLocation();
            if (o instanceof Criterion) {
                Criterion c = (Criterion)o;
                this.moveCriterion(c, jdl.getChildIndex());
                return true;
            }
            if (o instanceof Alternative && this.smaaModel.getAlternatives().contains(o)) {
                Alternative a = (Alternative)o;
                this.moveAlternative(a, jdl.getChildIndex());
                return true;
            }
            if (o instanceof Alternative) {
                Alternative a = (Alternative)o;
                this.moveCategory(a, jdl.getChildIndex());
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isLeftTree(Component component) {
        JTree jtree;
        return component instanceof JTree && (jtree = (JTree)component).getModel() instanceof LeftTreeModel;
    }

    public void moveCriterion(Criterion toMove, int newIndex) {
        int oldIndex = this.smaaModel.getCriteria().indexOf(toMove);
        if (oldIndex == newIndex) {
            return;
        }
        ArrayList<Criterion> newCrit = new ArrayList<Criterion>(this.smaaModel.getCriteria());
        this.swap(newCrit, newIndex, oldIndex);
        this.smaaModel.reorderCriteria(newCrit);
    }

    public void moveAlternative(Alternative toMove, int newIndex) {
        int oldIndex = this.smaaModel.getAlternatives().indexOf(toMove);
        if (oldIndex == newIndex) {
            return;
        }
        ArrayList<Alternative> newAlts = new ArrayList<Alternative>(this.smaaModel.getAlternatives());
        this.swap(newAlts, newIndex, oldIndex);
        this.smaaModel.reorderAlternatives(newAlts);
    }

    public void moveCategory(Alternative toMove, int newIndex) {
        if (!(this.smaaModel instanceof SMAATRIModel)) {
            return;
        }
        int oldIndex = ((SMAATRIModel)this.smaaModel).getCategories().indexOf(toMove);
        if (oldIndex == newIndex) {
            return;
        }
        ArrayList<Alternative> newAlts = new ArrayList<Alternative>(((SMAATRIModel)this.smaaModel).getCategories());
        this.swap(newAlts, newIndex, oldIndex);
        ((SMAATRIModel)this.smaaModel).reorderCategories(newAlts);
    }

    private <T> void swap(List<T> list, int index1, int index2) {
        T toMove1 = list.get(index1);
        T toMove2 = list.get(index2);
        list.set(index2, toMove1);
        list.set(index1, toMove2);
    }
}

