/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.gui.presentation.LeftTreeModel;
import fi.smaa.jsmaa.gui.presentation.LeftTreeModelSMAATRI;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.ScaleCriterion;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.drugis.common.ImageLoader;

public class LeftTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6982388941837275497L;
    private LeftTreeModel model;

    public LeftTreeCellRenderer(LeftTreeModel model) {
        this.model = model;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf && value instanceof Alternative) {
            this.setIcon(ImageLoader.getIcon("alternative.gif"));
            this.setToolTipText("Alternative");
        } else if (leaf && value instanceof Criterion) {
            if (value instanceof ScaleCriterion) {
                this.setIcon(ImageLoader.getIcon("criterion_cardinal.gif"));
                this.setToolTipText("Cardinal criterion");
            } else if (value instanceof OutrankingCriterion) {
                this.setIcon(ImageLoader.getIcon("criterion_outranking.gif"));
                this.setToolTipText("Outranking criterion");
            } else if (value instanceof OrdinalCriterion) {
                this.setIcon(ImageLoader.getIcon("criterion_ordinal.gif"));
                this.setToolTipText("Ordinal criterion");
            }
        } else if (value == this.model.getCentralWeightsNode()) {
            this.setIcon(ImageLoader.getIcon("centralweights.gif"));
            this.setToolTipText("Central weights");
        } else if (value == this.model.getRankAcceptabilitiesNode()) {
            this.setIcon(ImageLoader.getIcon("rankacceptabilities.gif"));
            this.setToolTipText("Rank acceptability indices");
        } else if (value == this.model.getPreferencesNode()) {
            this.setIcon(ImageLoader.getIcon("preferences.gif"));
            this.setToolTipText("Preference information");
        } else if (this.model instanceof LeftTreeModelSMAATRI && ((LeftTreeModelSMAATRI)this.model).getCatAccNode() == value) {
            this.setIcon(ImageLoader.getIcon("rankacceptabilities.gif"));
            this.setToolTipText("Category acceptability indices");
        } else {
            this.setToolTipText(null);
        }
        return this;
    }
}

