/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.SMAAModel;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;

public class LeftTreeCellEditor
extends DefaultTreeCellEditor {
    private ArrayList<String> oldNames = new ArrayList();
    private String oldName;
    private SMAAModel model;
    JTree tree;
    private Object editObject;

    public LeftTreeCellEditor(SMAAModel model, JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        this.model = model;
        this.tree = tree;
        this.addCellEditorListener(new MyCellEditorListener());
    }

    private void showErrorCriterionExists(String name) {
        JOptionPane.showMessageDialog(this.tree, "There exists a criterion with name: " + name + ", input another one.", "Input error", 0);
    }

    private void showErrorAlternativeExists(String name) {
        JOptionPane.showMessageDialog(this.tree, "There exists an alternative with name: " + name + ", input another one.", "Input error", 0);
    }

    private boolean isValidName(String name) {
        return !this.oldNames.contains(name) || name.equals(this.oldName);
    }

    @Override
    public void prepareForEditing() {
        this.oldNames.clear();
        this.editObject = this.lastPath.getLastPathComponent();
        if (this.editObject instanceof Alternative) {
            this.oldName = ((Alternative)this.editObject).getName();
            for (Alternative a : this.model.getAlternatives()) {
                this.oldNames.add(a.getName());
            }
        } else if (this.editObject instanceof Criterion) {
            this.oldName = ((Criterion)this.editObject).getName();
            for (Criterion c : this.model.getCriteria()) {
                this.oldNames.add(c.getName());
            }
        }
        super.prepareForEditing();
    }

    private class MyCellEditorListener
    implements CellEditorListener {
        private MyCellEditorListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this.validateEditing();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this.validateEditing();
        }

        private void validateEditing() {
            String newName = (String)LeftTreeCellEditor.this.getCellEditorValue();
            if (LeftTreeCellEditor.this.editObject instanceof Alternative) {
                if (!LeftTreeCellEditor.this.isValidName(newName)) {
                    LeftTreeCellEditor.this.showErrorAlternativeExists(newName);
                    LeftTreeCellEditor.this.tree.startEditingAtPath(LeftTreeCellEditor.this.lastPath);
                }
            } else if (LeftTreeCellEditor.this.editObject instanceof Criterion && !LeftTreeCellEditor.this.isValidName(newName)) {
                LeftTreeCellEditor.this.showErrorCriterionExists(newName);
                LeftTreeCellEditor.this.tree.startEditingAtPath(LeftTreeCellEditor.this.lastPath);
            }
        }
    }
}

