/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.AppInfo;
import fi.smaa.jsmaa.ModelFileManager;
import fi.smaa.jsmaa.gui.Focuser;
import fi.smaa.jsmaa.gui.GUIFactory;
import fi.smaa.jsmaa.gui.MenuDirector;
import fi.smaa.jsmaa.gui.MyFileFilter;
import fi.smaa.jsmaa.gui.SMAA2GUIFactory;
import fi.smaa.jsmaa.gui.SMAA2SimulationBuilder;
import fi.smaa.jsmaa.gui.SMAATRIGUIFactory;
import fi.smaa.jsmaa.gui.SMAATRISimulationBuilder;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ModelChangeEvent;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAAModelListener;
import fi.smaa.jsmaa.model.SMAATRIModel;
import fi.smaa.jsmaa.model.xml.InvalidModelVersionException;
import fi.smaa.jsmaa.model.xml.JSMAABinding;
import fi.smaa.jsmaa.simulator.BuildQueue;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.drugis.common.ImageLoader;
import org.drugis.common.gui.FileLoadDialog;
import org.drugis.common.gui.FileSaveDialog;
import org.drugis.common.gui.ViewBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.StandardChartTheme;

public class JSMAAMainFrame
extends JFrame
implements MenuDirector {
    public static final Object JSMAA_MODELFILE_EXTENSION = "jsmaa";
    private ViewBuilder rightViewBuilder;
    private JScrollPane rightPane;
    private SMAAModelListener modelListener = new MySMAAModelListener();
    private GUIFactory guiFactory;
    public ModelFileManager modelManager;
    public BuildQueue buildQueue = new BuildQueue();
    public NameListener nameListener = new NameListener();

    public JSMAAMainFrame(SMAAModel model) {
        super(AppInfo.getAppName());
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ImageLoader.setImagePath("/fi/smaa/jsmaa/gui/");
        this.setPreferredSize(new Dimension(1000, 800));
        this.setDefaultCloseOperation(0);
        this.modelManager = new ModelFileManager();
        this.modelManager.addPropertyChangeListener("title", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                JSMAAMainFrame.this.setTitle((String)ev.getNewValue());
            }
        });
        this.modelManager.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JSMAAMainFrame.this.initWithModel((SMAAModel)evt.getNewValue());
            }
        });
        this.modelManager.setModel(model);
    }

    public void initWithModel(SMAAModel model) {
        this.guiFactory = model instanceof SMAATRIModel ? new SMAATRIGUIFactory((Window)this, (SMAATRIModel)model, (MenuDirector)this) : new SMAA2GUIFactory((Window)this, model, (MenuDirector)this);
        this.rebuildGUI();
        this.buildNewSimulator();
        model.addModelListener(this.modelListener);
        Focuser.focus(this.guiFactory.getTree(), this.guiFactory.getTreeModel(), this.guiFactory.getTreeModel().getCriteriaNode());
        this.reconnectNameListeners();
    }

    private void reconnectNameListeners() {
        for (Alternative a : this.modelManager.getModel().getAlternatives()) {
            a.addPropertyChangeListener(this.nameListener);
        }
        if (this.modelManager.getModel() instanceof SMAATRIModel) {
            for (Alternative cat : ((SMAATRIModel)this.modelManager.getModel()).getCategories()) {
                cat.addPropertyChangeListener(this.nameListener);
            }
        }
        for (Criterion c : this.modelManager.getModel().getCriteria()) {
            c.addPropertyChangeListener(this.nameListener);
        }
    }

    private void rebuildGUI() {
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.1);
        splitPane.setDividerSize(2);
        splitPane.setDividerLocation(-1);
        this.rightPane = new JScrollPane();
        this.rightPane.getVerticalScrollBar().setUnitIncrement(16);
        splitPane.setRightComponent(this.rightPane);
        JScrollPane leftScrollPane = new JScrollPane();
        leftScrollPane.setViewportView(this.guiFactory.getTree());
        splitPane.setLeftComponent(leftScrollPane);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", splitPane);
        this.getContentPane().add("North", this.guiFactory.getTopToolBar());
        this.getContentPane().add("South", this.guiFactory.getBottomToolBar());
        this.setJMenuBar(this.guiFactory.getMenuBar());
        this.guiFactory.getTree().addTreeSelectionListener(new LeftTreeSelectionListener());
        this.pack();
    }

    private void rebuildRightPanel() {
        this.rightPane.setViewportView(this.rightViewBuilder.buildPanel());
    }

    @Override
    public void quit() {
        for (WindowListener w : this.getWindowListeners()) {
            w.windowClosing(new WindowEvent(this, 201));
        }
    }

    @Override
    public void newModel(SMAAModel newModel) {
        if (!this.checkSaveCurrentModel()) {
            return;
        }
        this.modelManager.setModel(newModel);
    }

    @Override
    public boolean saveAs() {
        FileSaveDialog d = new FileSaveDialog(this, "jsmaa", "JSMAA model files"){

            @Override
            public void doAction(String path, String extension) {
                File file = JSMAAMainFrame.this.checkFileExtension(new File(path));
                this.setLastSuccess(JSMAAMainFrame.this.trySaveModel(file));
                JSMAAMainFrame.this.modelManager.setModelFile(file);
            }
        };
        return d.getLastSuccess();
    }

    private boolean checkSaveCurrentModel() {
        if (!this.modelManager.getSaved()) {
            int conf = JOptionPane.showConfirmDialog(this, "Current model not saved. Do you want do save changes?", "Save changed", 1, 3, ImageLoader.getIcon("stop.gif"));
            if (conf == 2) {
                return false;
            }
            if (conf == 0 && !this.save()) {
                return false;
            }
        }
        return true;
    }

    private boolean trySaveModel(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            JSMAABinding.writeModel(this.modelManager.getModel(), new BufferedOutputStream(fos));
            fos.close();
            this.modelManager.setSaved(true);
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving model to " + this.getCanonicalPath(file) + ", " + e.getMessage(), "Save error", 0);
            return false;
        }
    }

    @Override
    public boolean save() {
        if (this.modelManager.getModelFile() == null) {
            return this.saveAs();
        }
        return this.trySaveModel(this.modelManager.getModelFile());
    }

    @Override
    public void open() {
        if (!this.checkSaveCurrentModel()) {
            return;
        }
        new FileLoadDialog(this, "jsmaa", "JSMAA model files"){

            @Override
            public void doAction(String path, String extension) {
                try {
                    File file = new File(path);
                    FileInputStream fis = new FileInputStream(file);
                    SMAAModel loadedModel = JSMAABinding.readModel(new BufferedInputStream(fis));
                    ((InputStream)fis).close();
                    JSMAAMainFrame.this.modelManager.setModel(loadedModel);
                    JSMAAMainFrame.this.modelManager.setModelFile(file);
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(JSMAAMainFrame.this, "Error loading model: " + e.getMessage(), "Load error", 0);
                }
                catch (InvalidModelVersionException e) {
                    JSMAAMainFrame.this.showErrorIncompatibleModel(path, "file contains a an incompatible JSMAA model version " + e.getVersion() + ".\nOnly versions until " + 2 + " supported.\nTo open the file, upgrade to a newer version of JSMAA (www.smaa.fi)");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JSMAAMainFrame.this.showErrorIncompatibleModel(path, "file doesn't dontain a JSMAA model");
                }
            }
        };
    }

    private void showErrorIncompatibleModel(String file, String reason) {
        JOptionPane.showMessageDialog(this, "Error loading model from " + file + ": " + reason + ".", "Load error", 0);
    }

    private String getCanonicalPath(File selectedFile) {
        try {
            return selectedFile.getCanonicalPath();
        }
        catch (Exception e) {
            return selectedFile.toString();
        }
    }

    private File checkFileExtension(File file) {
        if (MyFileFilter.getExtension(file) == null || !MyFileFilter.getExtension(file).equals(JSMAA_MODELFILE_EXTENSION)) {
            return new File(file.getAbsolutePath() + "." + JSMAA_MODELFILE_EXTENSION);
        }
        return file;
    }

    private void buildNewSimulator() {
        if (this.modelManager.getModel() instanceof SMAATRIModel) {
            this.buildQueue.add(new SMAATRISimulationBuilder((SMAATRIModel)this.modelManager.getModel(), this.guiFactory, (JFrame)this));
        } else {
            this.buildQueue.add(new SMAA2SimulationBuilder(this.modelManager.getModel(), this.guiFactory, (JFrame)this));
        }
    }

    public MenuDirector getMenuDirector() {
        return this;
    }

    @Override
    public ModelFileManager getFileManager() {
        return this.modelManager;
    }

    private class NameListener
    implements PropertyChangeListener {
        private NameListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("name") && !ev.getNewValue().equals(ev.getOldValue())) {
                JSMAAMainFrame.this.modelManager.setSaved(false);
            }
        }
    }

    private class MySMAAModelListener
    implements SMAAModelListener {
        private MySMAAModelListener() {
        }

        @Override
        public void modelChanged(ModelChangeEvent ev) {
            JSMAAMainFrame.this.buildNewSimulator();
            switch (ev.getType()) {
                case 1: 
                case 2: 
                case 7: {
                    JSMAAMainFrame.this.reconnectNameListeners();
                    Focuser.focus(JSMAAMainFrame.this.guiFactory.getTree(), JSMAAMainFrame.this.guiFactory.getTreeModel(), JSMAAMainFrame.this.guiFactory.getTreeModel().getModelNode());
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                default: {
                    JSMAAMainFrame.this.rebuildRightPanel();
                }
            }
        }
    }

    private class LeftTreeSelectionListener
    implements TreeSelectionListener {
        private LeftTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() == null) {
                return;
            }
            Object node = e.getNewLeadSelectionPath().getLastPathComponent();
            JSMAAMainFrame.this.rightViewBuilder = JSMAAMainFrame.this.guiFactory.buildView(node);
            JSMAAMainFrame.this.rebuildRightPanel();
        }
    }
}

