/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import fi.smaa.jsmaa.gui.GUIFactory;
import fi.smaa.jsmaa.gui.SMAA2GUIFactory;
import fi.smaa.jsmaa.gui.SMAATRIGUIFactory;
import fi.smaa.jsmaa.model.NamedObject;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAATRIModel;
import fi.smaa.jsmaa.simulator.ResultsEvent;
import fi.smaa.jsmaa.simulator.SMAA2Results;
import fi.smaa.jsmaa.simulator.SMAAResults;
import fi.smaa.jsmaa.simulator.SMAAResultsListener;
import fi.smaa.jsmaa.simulator.SMAASimulation;
import fi.smaa.jsmaa.simulator.SMAATRIResults;
import fi.smaa.jsmaa.simulator.SimulationBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JFrame;

public abstract class BasicSimulationBuilder<M extends SMAAModel, R extends SMAAResults, T extends SMAASimulation<M>>
extends SimulationBuilder<M, R, T> {
    private GUIFactory factory;
    private JFrame frame;
    public int ITERATIONS = 10000;

    public BasicSimulationBuilder(M model, GUIFactory factory, JFrame frame) {
        super(model);
        this.factory = factory;
        this.frame = frame;
        this.connectNameAdapters(((SMAAModel)model).getAlternatives(), this.model.getAlternatives());
        this.connectNameAdapters(((SMAAModel)model).getCriteria(), this.model.getCriteria());
    }

    @Override
    protected void prepareSimulation(T simulation, R results) {
        ((SMAAResults)results).addResultsListener(new SimulationProgressListener());
        if (this.model instanceof SMAATRIModel) {
            ((SMAATRIGUIFactory)this.factory).setResults((SMAATRIResults)results);
        } else {
            ((SMAA2GUIFactory)this.factory).setResults((SMAA2Results)results);
        }
        this.factory.getProgressModel().setTask(((SMAASimulation)simulation).getTask());
    }

    protected void connectNameAdapters(List<? extends NamedObject> oldModelObjects, List<? extends NamedObject> newModelObjects) {
        assert (oldModelObjects.size() == newModelObjects.size());
        for (int i = 0; i < oldModelObjects.size(); ++i) {
            NamedObject mCrit = oldModelObjects.get(i);
            NamedObject nmCrit = newModelObjects.get(i);
            mCrit.addPropertyChangeListener(new NameUpdater(nmCrit));
        }
    }

    private class SimulationProgressListener
    implements SMAAResultsListener {
        private SimulationProgressListener() {
        }

        @Override
        public void resultsChanged(ResultsEvent ev) {
            if (ev.getException() != null) {
                BasicSimulationBuilder.this.frame.getContentPane().remove(BasicSimulationBuilder.this.factory.getBottomToolBar());
                BasicSimulationBuilder.this.frame.getContentPane().add("South", BasicSimulationBuilder.this.factory.getBottomToolBar());
                BasicSimulationBuilder.this.frame.pack();
            }
        }
    }

    private class NameUpdater
    implements PropertyChangeListener {
        private NamedObject toUpdate;

        public NameUpdater(NamedObject toUpdate) {
            this.toUpdate = toUpdate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("name")) {
                this.toUpdate.setName((String)evt.getNewValue());
            }
        }
    }
}

