/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.looks.HeaderStyle;
import fi.smaa.jsmaa.AppInfo;
import fi.smaa.jsmaa.DefaultModels;
import fi.smaa.jsmaa.gui.Focuser;
import fi.smaa.jsmaa.gui.GUIFactory;
import fi.smaa.jsmaa.gui.LeftTreeCellEditor;
import fi.smaa.jsmaa.gui.LeftTreeCellRenderer;
import fi.smaa.jsmaa.gui.LeftTreeTransferHandler;
import fi.smaa.jsmaa.gui.MenuDirector;
import fi.smaa.jsmaa.gui.presentation.LeftTreeModel;
import fi.smaa.jsmaa.gui.presentation.ModelFileManagerPM;
import fi.smaa.jsmaa.gui.presentation.PreferencePresentationModel;
import fi.smaa.jsmaa.gui.views.AlternativeInfoView;
import fi.smaa.jsmaa.gui.views.AlternativeView;
import fi.smaa.jsmaa.gui.views.CriteriaListView;
import fi.smaa.jsmaa.gui.views.CriterionView;
import fi.smaa.jsmaa.gui.views.PreferenceInformationView;
import fi.smaa.jsmaa.gui.views.ViewWithHeader;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.SMAAModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import org.drugis.common.ImageLoader;
import org.drugis.common.gui.ViewBuilder;
import org.drugis.common.gui.task.TaskProgressBar;
import org.drugis.common.gui.task.TaskProgressModel;
import org.drugis.common.threading.NullTask;

public abstract class AbstractGUIFactory<T extends LeftTreeModel, M extends SMAAModel>
implements GUIFactory {
    protected T treeModel;
    protected M smaaModel;
    private JMenuItem editRenameItem;
    private JMenuItem editDeleteItem;
    protected JToolBar topToolBar;
    protected JMenuBar menuBar;
    protected JTree tree;
    protected MenuDirector director;
    protected ModelFileManagerPM fileManagerPM;
    private JToolBar bottomToolBar;
    private TaskProgressBar progressBar;
    private TaskProgressModel progressModel;
    protected Window parent;

    protected AbstractGUIFactory(Window parent, M smaaModel, MenuDirector director) {
        this.parent = parent;
        this.fileManagerPM = new ModelFileManagerPM(director.getFileManager());
        this.smaaModel = smaaModel;
        this.treeModel = this.buildTreeModel();
        this.director = director;
        this.progressModel = new TaskProgressModel(new NullTask());
        this.progressBar = new TaskProgressBar(this.progressModel);
        this.menuBar = this.buildMenuBar();
        this.tree = this.buildTree();
        this.topToolBar = this.buildTopToolBar();
        this.bottomToolBar = this.buildBottomToolBar();
    }

    public T getTreeModel() {
        return this.treeModel;
    }

    @Override
    public TaskProgressModel getProgressModel() {
        return this.progressModel;
    }

    @Override
    public JToolBar getTopToolBar() {
        return this.topToolBar;
    }

    @Override
    public JToolBar getBottomToolBar() {
        return this.bottomToolBar;
    }

    protected JToolBar buildBottomToolBar() {
        JToolBar bar = new JToolBar();
        bar.setLayout(new BorderLayout());
        bar.add((Component)this.progressBar, "Center");
        bar.setFloatable(false);
        return bar;
    }

    @Override
    public TaskProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected JToolBar buildTopToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        JButton topBarOpenButton = new JButton(ImageLoader.getIcon("openfile.gif"));
        topBarOpenButton.setToolTipText("Open");
        topBarOpenButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.director.open();
            }
        });
        bar.add(topBarOpenButton);
        JButton topBarSaveButton = new JButton(ImageLoader.getIcon("savefile.gif"));
        topBarSaveButton.setToolTipText("Save");
        topBarSaveButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.director.save();
            }
        });
        bar.add(topBarSaveButton);
        Bindings.bind(topBarSaveButton, "enabled", this.fileManagerPM.getUnsavedModel());
        bar.addSeparator();
        JButton addButton = new JButton(ImageLoader.getIcon("add_alternative.gif"));
        addButton.setToolTipText("Add alternative");
        addButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.addAlternative();
            }
        });
        bar.add(addButton);
        JButton addCritButton = this.buildToolBarAddCriterionButton();
        bar.add(addCritButton);
        return bar;
    }

    protected abstract JButton buildToolBarAddCriterionButton();

    protected abstract T buildTreeModel();

    protected abstract JMenu buildResultsMenu();

    protected abstract JMenuItem buildAddCriterionItem();

    @Override
    public ViewBuilder buildView(Object o) {
        if (o == ((LeftTreeModel)this.treeModel).getAlternativesNode()) {
            return new ViewWithHeader("Alternatives", new AlternativeInfoView(((SMAAModel)this.smaaModel).getAlternatives()));
        }
        if (o == ((LeftTreeModel)this.treeModel).getCriteriaNode()) {
            return new ViewWithHeader("Criteria", new CriteriaListView((SMAAModel)this.smaaModel));
        }
        if (o instanceof Criterion) {
            return new ViewWithHeader("Criterion", new CriterionView((Criterion)o, (SMAAModel)this.smaaModel));
        }
        if (o instanceof Alternative) {
            return new ViewWithHeader("Alternative", new AlternativeView((Alternative)o, ((SMAAModel)this.smaaModel).getImpactMatrix()));
        }
        if (o == ((LeftTreeModel)this.treeModel).getPreferencesNode()) {
            return new ViewWithHeader("Preferences", new PreferenceInformationView(new PreferencePresentationModel((SMAAModel)this.smaaModel, true)));
        }
        if (o == ((LeftTreeModel)this.treeModel).getResultsNode()) {
            return new ViewBuilder(){

                @Override
                public JComponent buildPanel() {
                    return new JPanel();
                }
            };
        }
        if (o == ((LeftTreeModel)this.treeModel).getModelNode()) {
            return new ViewBuilder(){

                @Override
                public JComponent buildPanel() {
                    return new JPanel();
                }
            };
        }
        throw new IllegalArgumentException("no view known for object " + o);
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        for (JMenuItem l : this.getEntityMenuList()) {
            menuBar.add(l);
        }
        menuBar.add(this.buildResultsMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    protected List<JMenuItem> getEntityMenuList() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        list.add(this.buildFileMenu());
        list.add(this.buildEditMenu());
        list.add(this.buildCriteriaMenu());
        list.add(this.buildAlternativeMenu());
        return list;
    }

    private JTree buildTree() {
        final JTree tree = new JTree((TreeModel)this.treeModel);
        tree.setEditable(true);
        LeftTreeCellRenderer renderer = new LeftTreeCellRenderer((LeftTreeModel)this.treeModel);
        tree.setCellEditor(new LeftTreeCellEditor((SMAAModel)this.smaaModel, tree, renderer));
        tree.setCellRenderer(renderer);
        tree.setDragEnabled(true);
        tree.setTransferHandler(new LeftTreeTransferHandler((LeftTreeModel)this.treeModel, (SMAAModel)this.smaaModel));
        tree.setDropMode(DropMode.INSERT);
        final JPopupMenu leftTreeEditPopupMenu = new JPopupMenu();
        JMenuItem leftTreeRenameItem = this.buildRenameItem();
        leftTreeEditPopupMenu.add(leftTreeRenameItem);
        final JMenuItem leftTreeDeleteItem = this.buildDeleteItem();
        leftTreeEditPopupMenu.add(leftTreeDeleteItem);
        final JPopupMenu leftTreeAltsPopupMenu = new JPopupMenu();
        leftTreeAltsPopupMenu.add(this.buildAddAlternativeItem());
        final JPopupMenu leftTreeCritPopupMenu = new JPopupMenu();
        leftTreeCritPopupMenu.add(this.buildAddCriterionItem());
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                int selRow;
                if (evt.isPopupTrigger() && (selRow = tree.getRowForLocation(evt.getX(), evt.getY())) != -1) {
                    Object obj = tree.getPathForLocation(evt.getX(), evt.getY()).getLastPathComponent();
                    tree.setSelectionRow(selRow);
                    if (obj instanceof Alternative || obj instanceof Criterion || obj instanceof SMAAModel) {
                        leftTreeDeleteItem.setEnabled(!(obj instanceof SMAAModel));
                        leftTreeEditPopupMenu.show((Component)evt.getSource(), evt.getX(), evt.getY());
                    } else if (obj == ((LeftTreeModel)AbstractGUIFactory.this.treeModel).getAlternativesNode()) {
                        leftTreeAltsPopupMenu.show((Component)evt.getSource(), evt.getX(), evt.getY());
                    } else if (obj == ((LeftTreeModel)AbstractGUIFactory.this.treeModel).getCriteriaNode()) {
                        leftTreeCritPopupMenu.show((Component)evt.getSource(), evt.getX(), evt.getY());
                    }
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                Object node = ev.getPath().getLastPathComponent();
                if (node instanceof Alternative || node instanceof Criterion) {
                    AbstractGUIFactory.this.editDeleteItem.setEnabled(true);
                    AbstractGUIFactory.this.editRenameItem.setEnabled(true);
                } else if (node == ((LeftTreeModel)AbstractGUIFactory.this.treeModel).getModelNode()) {
                    AbstractGUIFactory.this.editDeleteItem.setEnabled(false);
                    AbstractGUIFactory.this.editRenameItem.setEnabled(true);
                } else {
                    AbstractGUIFactory.this.editDeleteItem.setEnabled(false);
                    AbstractGUIFactory.this.editRenameItem.setEnabled(false);
                }
            }
        });
        return tree;
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('h');
        JMenuItem aboutItem = new JMenuItem("About", ImageLoader.getIcon("home.gif"));
        aboutItem.setMnemonic('a');
        aboutItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractGUIFactory.this.showAboutDialog();
            }
        });
        helpMenu.add(aboutItem);
        return helpMenu;
    }

    private void showAboutDialog() {
        String title = "About " + AppInfo.getAppName();
        String msg = "JSMAA v" + AppInfo.getAppVersion();
        msg = msg + "\n" + AppInfo.getAppName() + " is open source and licensed under GPLv3.\n";
        msg = msg + "\t- and can be distributed freely!\n";
        msg = msg + "(c) 2009-2010 Tommi Tervonen <tommi at smaa dot fi>";
        JOptionPane.showMessageDialog(this.parent, msg, title, 1, ImageLoader.getIcon("home.gif"));
    }

    private JMenu buildAlternativeMenu() {
        JMenu alternativeMenu = new JMenu("Alternatives");
        alternativeMenu.setMnemonic('a');
        JMenuItem showItem = new JMenuItem("Show");
        showItem.setMnemonic('s');
        JMenuItem addAlternativeItem = this.buildAddAlternativeItem();
        showItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Focuser.focus(AbstractGUIFactory.this.tree, AbstractGUIFactory.this.treeModel, ((LeftTreeModel)AbstractGUIFactory.this.treeModel).getAlternativesNode());
            }
        });
        alternativeMenu.add(showItem);
        alternativeMenu.addSeparator();
        alternativeMenu.add(addAlternativeItem);
        return alternativeMenu;
    }

    private JMenuItem buildAddAlternativeItem() {
        JMenuItem item = new JMenuItem("Add new");
        item.setMnemonic('n');
        item.setIcon(ImageLoader.getIcon("add_alternative.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        item.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.addAlternative();
            }
        });
        return item;
    }

    private JMenu buildCriteriaMenu() {
        JMenu criteriaMenu = new JMenu("Criteria");
        criteriaMenu.setMnemonic('c');
        JMenuItem showItem = new JMenuItem("Show");
        showItem.setMnemonic('s');
        showItem.setIcon(ImageLoader.getIcon("criterialist.gif"));
        showItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Focuser.focus(AbstractGUIFactory.this.tree, AbstractGUIFactory.this.treeModel, ((LeftTreeModel)AbstractGUIFactory.this.treeModel).getCriteriaNode());
            }
        });
        JMenuItem addCardItem = this.buildAddCriterionItem();
        criteriaMenu.add(showItem);
        criteriaMenu.addSeparator();
        criteriaMenu.add(addCardItem);
        return criteriaMenu;
    }

    private JMenu buildEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('e');
        this.editRenameItem = this.buildRenameItem();
        this.editRenameItem.setEnabled(false);
        this.editDeleteItem = this.buildDeleteItem();
        this.editDeleteItem.setEnabled(false);
        editMenu.add(this.editRenameItem);
        editMenu.add(this.editDeleteItem);
        return editMenu;
    }

    private JMenuItem buildDeleteItem() {
        JMenuItem item = new JMenuItem("Delete", ImageLoader.getIcon("delete.gif"));
        item.setMnemonic('d');
        item.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        item.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.menuDeleteClicked();
            }
        });
        return item;
    }

    private JMenuItem buildRenameItem() {
        JMenuItem item = new JMenuItem("Rename", ImageLoader.getIcon("rename.gif"));
        item.setMnemonic('r');
        item.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        item.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.tree.startEditingAtPath(AbstractGUIFactory.this.tree.getSelectionPath());
            }
        });
        return item;
    }

    private JMenu buildFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        JMenu newMenu = new JMenu("New model");
        newMenu.setMnemonic('n');
        newMenu.setIcon(ImageLoader.getIcon("filenew.gif"));
        JMenuItem newSMAA2Item = new JMenuItem("SMAA-2");
        newSMAA2Item.setMnemonic('2');
        newSMAA2Item.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractGUIFactory.this.director.newModel(DefaultModels.getSMAA2Model());
            }
        });
        JMenuItem newSMAATRIItem = new JMenuItem("SMAA-TRI");
        newSMAATRIItem.setMnemonic('t');
        newSMAATRIItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractGUIFactory.this.director.newModel(DefaultModels.getSMAATRIModel());
            }
        });
        newMenu.add(newSMAA2Item);
        newMenu.add(newSMAATRIItem);
        JMenu newItem = newMenu;
        JMenuItem saveItem = new JMenuItem("Save");
        saveItem.setMnemonic('s');
        saveItem.setIcon(ImageLoader.getIcon("savefile.gif"));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        Bindings.bind(saveItem, "enabled", this.fileManagerPM.getUnsavedModel());
        JMenuItem saveAsItem = new JMenuItem("Save As");
        saveAsItem.setMnemonic('a');
        saveAsItem.setIcon(ImageLoader.getIcon("saveas.gif"));
        JMenuItem openItem = new JMenuItem("Open");
        openItem.setMnemonic('o');
        openItem.setIcon(ImageLoader.getIcon("openfile.gif"));
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem quitItem = new JMenuItem("Quit");
        quitItem.setMnemonic('q');
        quitItem.setIcon(ImageLoader.getIcon("stop.gif"));
        quitItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.director.quit();
            }
        });
        saveItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.director.save();
            }
        });
        saveAsItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.director.saveAs();
            }
        });
        openItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGUIFactory.this.director.open();
            }
        });
        fileMenu.add(newItem);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        fileMenu.add(quitItem);
        return fileMenu;
    }

    protected String generateNextCriterionName() {
        List<Criterion> crit = ((SMAAModel)this.smaaModel).getCriteria();
        int index = 1;
        while (true) {
            String testName = "Criterion " + index;
            boolean found = false;
            for (Criterion c : crit) {
                if (!testName.equals(c.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                return "Criterion " + index;
            }
            ++index;
        }
    }

    protected void addCriterionAndStartRename(Criterion c) {
        ((SMAAModel)this.smaaModel).addCriterion(c);
        Focuser.focus(this.tree, this.treeModel, c);
        this.tree.startEditingAtPath(((LeftTreeModel)this.treeModel).getPathForCriterion(c));
    }

    protected void addAlternativeAndStartRename(Alternative a) {
        ((SMAAModel)this.smaaModel).addAlternative(a);
        Focuser.focus(this.tree, this.treeModel, a);
        this.tree.startEditingAtPath(((LeftTreeModel)this.treeModel).getPathForAlternative(a));
    }

    public void menuDeleteClicked() {
        Object selection = this.tree.getSelectionPath().getLastPathComponent();
        if (selection instanceof Alternative) {
            this.confirmDeleteAlternative((Alternative)selection);
        } else if (selection instanceof Criterion) {
            this.confirmDeleteCriterion((Criterion)selection);
        }
    }

    private void confirmDeleteCriterion(Criterion criterion) {
        int conf = JOptionPane.showConfirmDialog(this.parent, "Do you really want to delete criterion " + criterion + "?", "Confirm deletion", 0, 3, ImageLoader.getIcon("delete.gif"));
        if (conf == 0) {
            ((SMAAModel)this.smaaModel).deleteCriterion(criterion);
        }
    }

    protected void confirmDeleteAlternative(Alternative alternative) {
        String typeName = "alternative";
        int conf = JOptionPane.showConfirmDialog(this.parent, "Do you really want to delete " + typeName + " " + alternative + "?", "Confirm deletion", 0, 3, ImageLoader.getIcon("delete.gif"));
        if (conf == 0) {
            ((SMAAModel)this.smaaModel).deleteAlternative(alternative);
        }
    }

    private void addAlternative() {
        List<Alternative> alts = ((SMAAModel)this.smaaModel).getAlternatives();
        int index = 1;
        while (true) {
            Alternative a = new Alternative("Alternative " + index);
            boolean found = false;
            for (Alternative al : alts) {
                if (!al.getName().equals(a.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                this.addAlternativeAndStartRename(a);
                return;
            }
            ++index;
        }
    }

    protected boolean isChartDrawable() {
        return ((SMAAModel)this.smaaModel).getAlternatives().size() <= 20;
    }
}

