/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa;

import com.jgoodies.binding.beans.Model;
import fi.smaa.jsmaa.AppInfo;
import fi.smaa.jsmaa.model.ModelChangeEvent;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAAModelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;

public class ModelFileManager
extends Model {
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_MODELSAVED = "saved";
    public static final String PROPERTY_TITLE = "title";
    private File currentModelFile;
    private boolean modelSaved = true;
    private SMAAModel model;

    public boolean getSaved() {
        return this.modelSaved;
    }

    public String getTitle() {
        String file = "Unsaved model";
        if (this.currentModelFile != null) {
            try {
                file = this.currentModelFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "JSMAA v" + AppInfo.getAppVersion() + " - " + file + (this.modelSaved ? "" : "*");
    }

    public SMAAModel getModel() {
        return this.model;
    }

    public void setModel(SMAAModel model) {
        SMAAModel oldVal = this.model;
        this.model = model;
        this.currentModelFile = null;
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModelFileManager.this.setSaved(false);
            }
        });
        model.addModelListener(new SMAAModelListener(){

            @Override
            public void modelChanged(ModelChangeEvent type) {
                ModelFileManager.this.setSaved(false);
            }
        });
        this.firePropertyChange(PROPERTY_MODEL, oldVal, this.model);
        this.setSaved(true);
    }

    public void setModelFile(File f) {
        this.currentModelFile = f;
        this.setSaved(true);
    }

    public File getModelFile() {
        return this.currentModelFile;
    }

    public void setSaved(boolean saved) {
        boolean oldVal = this.modelSaved;
        this.modelSaved = saved;
        this.firePropertyChange(PROPERTY_MODELSAVED, oldVal, this.modelSaved);
        this.firePropertyChange(PROPERTY_TITLE, null, this.getTitle());
    }
}

