/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.SMAATRIModel;
import fi.smaa.jsmaa.model.ScaleCriterion;

public class DefaultModels {
    public static SMAAModel getSMAA2Model() {
        SMAAModel model = new SMAAModel("SMAA-2 Model");
        DefaultModels.addDefaultCriteria(model);
        DefaultModels.addDefaultAlternatives(model);
        return model;
    }

    private static void addDefaultCriteria(SMAAModel model) {
        model.addCriterion(new ScaleCriterion("Criterion 1"));
        model.addCriterion(new ScaleCriterion("Criterion 2"));
    }

    private static void addDefaultOutrankingCriteria(SMAAModel model) {
        model.addCriterion(new OutrankingCriterion("Criterion 1", true, new Interval(0.0, 0.0), new Interval(1.0, 1.0)));
        model.addCriterion(new OutrankingCriterion("Criterion 2", true, new Interval(0.0, 0.0), new Interval(1.0, 1.0)));
    }

    private static void addDefaultAlternatives(SMAAModel model) {
        model.addAlternative(new Alternative("Alternative 1"));
        model.addAlternative(new Alternative("Alternative 2"));
        model.addAlternative(new Alternative("Alternative 3"));
    }

    public static SMAATRIModel getSMAATRIModel() {
        SMAATRIModel model = new SMAATRIModel("SMAA-TRI Model");
        DefaultModels.addDefaultAlternatives(model);
        DefaultModels.addDefaultOutrankingCriteria(model);
        model.addCategory(new Alternative("Category 1"));
        model.addCategory(new Alternative("Category 2"));
        return model;
    }
}

