/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.common;

import cern.jet.random.Beta;
import cern.jet.random.Normal;
import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import java.util.Arrays;

public class RandomUtil {
    private static RandomEngine random = new DRand(666);
    private static Normal normal = new Normal(0.0, 1.0, random);
    private static Beta betaGen = new Beta(1.0, 1.0, random);

    public static double createGaussian(double mean, double stdev) {
        return normal.nextDouble(mean, stdev);
    }

    public static double createUnif01() {
        return random.nextDouble();
    }

    public static void createSumToRand(double[] dest, double sumTo) throws NullPointerException {
        assert (sumTo >= 0.0);
        if (dest == null) {
            throw new NullPointerException("destination array null");
        }
        int len = dest.length;
        for (int i = 0; i < len - 1; ++i) {
            dest[i] = RandomUtil.createUnif01() * sumTo;
        }
        dest[len - 1] = sumTo;
        Arrays.sort(dest);
        double last = 0.0;
        for (int i = 0; i < len; ++i) {
            double t = dest[i];
            dest[i] = t - last;
            last = t;
        }
    }

    public static void createSumToOneRand(double[] dest) throws NullPointerException {
        RandomUtil.createSumToRand(dest, 1.0);
    }

    public static void createSumToOneSorted(double[] dest) throws NullPointerException {
        RandomUtil.createSumToOneRand(dest);
        Arrays.sort(dest);
    }

    public static double createBeta(Double min, Double max, Double alpha, Double beta) {
        double r = betaGen.nextDouble(alpha, beta);
        return r * (max - min) + min;
    }
}

