/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.FastGradientPainter;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.CellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JideSwingUtilities
implements SwingConstants {
    private static final Logger LOGGER_FOCUS = Logger.getLogger(JideSwingUtilities.class.getName() + ".focus");
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static final String CLIENT_PROPERTY_SYNCHRONIZE_VIEW = "synchronizeViewChangeListener";
    private static PropertyChangeListener _setOpaqueTrueListener;
    private static PropertyChangeListener _setOpaqueFalseListener;
    private static final String OPAQUE_LISTENER = "setOpaqueRecursively.opaqueListener";
    public static final String SET_OPAQUE_RECURSIVELY_EXCLUDED = "setOpaqueRecursively.excluded";
    static RenderingHints renderingHints;
    private static Class<?> _radialGradientPaintClass;
    private static Constructor<?> _radialGradientPaintConstructor1;
    private static Constructor<?> _radialGradientPaintConstructor2;
    private static Class<?> _linearGradientPaintClass;
    private static Constructor<?> _linearGradientPaintConstructor1;
    private static Constructor<?> _linearGradientPaintConstructor2;
    protected static boolean tracingFocus;

    public static JPanel createLeftPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "Before");
        return ret;
    }

    public static JPanel createRightPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "After");
        return ret;
    }

    public static JPanel createTopPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "First");
        return ret;
    }

    public static JPanel createBottomPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "Last");
        return ret;
    }

    public static JPanel createCenterPanel(Component object) {
        NullPanel ret = new NullPanel(new GridBagLayout());
        ret.setOpaque(false);
        ret.add(object, new GridBagConstraints());
        return ret;
    }

    public static JPanel createLabeledComponent(JLabel title, Component component, Object constraint) {
        NullPanel ret = new NullPanel(new JideBorderLayout(3, 3));
        ret.setOpaque(false);
        ret.add((Component)title, constraint);
        title.setLabelFor(component);
        ret.add(component);
        return ret;
    }

    public static void centerWindow(Window childToCenter) {
        childToCenter.setLocationRelativeTo(childToCenter.getParent());
    }

    public static void globalCenterWindow(Window childToCenter) {
        childToCenter.setLocationRelativeTo(null);
    }

    public static void paintArrow(Graphics g, Color color, int startX, int startY, int width, int orientation) {
        Color oldColor = g.getColor();
        g.setColor(color);
        width = width / 2 * 2 + 1;
        if (orientation == 0) {
            for (int i = 0; i < (width + 1) / 2; ++i) {
                g.drawLine(startX + i, startY + i, startX + width - i - 1, startY + i);
            }
        } else if (orientation == 1) {
            for (int i = 0; i < (width + 1) / 2; ++i) {
                g.drawLine(startX + i, startY + i, startX + i, startY + width - i - 1);
            }
        }
        g.setColor(oldColor);
    }

    public static void paintArrow(JComponent c, Graphics g, Color color, int startX, int startY, int width, int orientation) {
        if (!c.getComponentOrientation().isLeftToRight()) {
            Color oldColor = g.getColor();
            g.setColor(color);
            width = width / 2 * 2 + 1;
            for (int i = 0; i < (width + 1) / 2; ++i) {
                g.drawLine(startX + width - i, startY + i, startX + width - i, startY + width - i - 1);
            }
            g.setColor(oldColor);
            return;
        }
        JideSwingUtilities.paintArrow(g, color, startX, startY, width, orientation);
    }

    public static void paintCross(Graphics g, Color color, int centerX, int centerY, int size, int width) {
        g.setColor(color);
        size /= 2;
        for (int i = 0; i < width; ++i) {
            g.drawLine(centerX - size, centerY - size, centerX + size, centerY + size);
            g.drawLine(centerX + size, centerY - size, centerX - size, centerY + size);
            ++centerX;
        }
    }

    public static Frame getFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static void toggleRTLnLTR(Component topContainer) {
        ComponentOrientation co = topContainer.getComponentOrientation();
        co = co == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
        topContainer.applyComponentOrientation(co);
    }

    public static void synchronizeView(final JViewport masterViewport, final JViewport slaveViewport, final int orientation) {
        ChangeListener c1 = new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                Dimension size = masterViewport.getSize();
                if (size.width == 0 || size.height == 0) {
                    return;
                }
                Object c2 = slaveViewport.getClientProperty(JideSwingUtilities.CLIENT_PROPERTY_SYNCHRONIZE_VIEW);
                try {
                    if (c2 instanceof ChangeListener) {
                        slaveViewport.removeChangeListener((ChangeListener)c2);
                    }
                    if (orientation == 0) {
                        Point v1 = masterViewport.getViewPosition();
                        Point v2 = slaveViewport.getViewPosition();
                        if (v1.x != v2.x) {
                            slaveViewport.setViewPosition(new Point(v1.x, v2.y));
                        }
                    } else if (orientation == 1) {
                        Point v1 = masterViewport.getViewPosition();
                        Point v2 = slaveViewport.getViewPosition();
                        if (v1.y != v2.y) {
                            slaveViewport.setViewPosition(new Point(v2.x, v1.y));
                        }
                    }
                }
                finally {
                    if (c2 instanceof ChangeListener) {
                        slaveViewport.addChangeListener((ChangeListener)c2);
                    }
                }
            }
        };
        masterViewport.addChangeListener(c1);
        masterViewport.putClientProperty(CLIENT_PROPERTY_SYNCHRONIZE_VIEW, c1);
    }

    public static int getButtonState(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return 5;
            }
            return 4;
        }
        if (model.isPressed() && model.isArmed()) {
            if (model.isRollover()) {
                return 1;
            }
            if (model.isSelected()) {
                return 3;
            }
        } else {
            if (b.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected()) {
                    return 1;
                }
                return 2;
            }
            if (model.isSelected()) {
                return 3;
            }
            if (b.hasFocus() && b.isFocusPainted()) {
                if (model.isSelected()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    public static int[] getButtonState(JideSplitButton b) {
        int[] states = new int[2];
        SplitButtonModel model = (SplitButtonModel)b.getModel();
        if (!model.isEnabled()) {
            states[0] = model.isButtonSelected() ? 5 : 4;
        } else if (b.hasFocus() && b.isFocusPainted()) {
            if (model.isButtonSelected()) {
                states[0] = 3;
                states[1] = 7;
            } else if (model.isSelected()) {
                states[0] = 7;
                states[1] = 3;
            } else {
                states[0] = 2;
                states[1] = 7;
            }
        } else if (model.isPressed() && model.isArmed()) {
            if (model.isButtonRollover()) {
                states[0] = 1;
                states[1] = 7;
            } else if (model.isRollover()) {
                states[0] = 7;
                states[1] = 2;
            }
        } else if (b.isRolloverEnabled() && model.isButtonRollover()) {
            if (model.isButtonSelected()) {
                states[0] = 1;
                states[1] = 7;
            } else if (model.isSelected()) {
                states[0] = 2;
                states[1] = 1;
            } else {
                states[0] = 2;
                states[1] = 7;
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isButtonSelected()) {
                states[0] = 1;
                states[1] = 2;
            } else if (model.isSelected()) {
                states[0] = 7;
                states[1] = 1;
            } else {
                states[0] = 7;
                states[1] = 2;
            }
        } else if (model.isButtonSelected()) {
            states[0] = 3;
            states[1] = 7;
        } else if (model.isSelected()) {
            states[0] = 7;
            states[1] = 3;
        } else {
            states[0] = 0;
            states[1] = 0;
        }
        return states;
    }

    public static boolean equals(Object o1, Object o2) {
        return JideSwingUtilities.equals(o1, o2, false);
    }

    public static boolean equals(Object o1, Object o2, boolean considerArray) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o2.getClass().isAssignableFrom(o1.getClass())) {
            return ((Comparable)o2).compareTo(o1) == 0;
        }
        if (considerArray && o1.getClass().isArray() && o2.getClass().isArray()) {
            int length2;
            int length1 = Array.getLength(o1);
            if (length1 != (length2 = Array.getLength(o2))) {
                return false;
            }
            for (int i = 0; i < length1; ++i) {
                boolean equals = JideSwingUtilities.equals(Array.get(o1, i), Array.get(o2, i));
                if (equals) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            if (g2 != null) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            }
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public static void setWindowOpacity(Window window, float opacity) {
        try {
            Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            Method mSetWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            mSetWindowOpacity.invoke(null, window, Float.valueOf(opacity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean shouldUseSystemFont() {
        boolean useSystemFontSettings;
        String property = SecurityUtils.getProperty("jide.useSystemfont", "");
        if ("false".equals(property)) {
            return false;
        }
        if ("true".equals(property)) {
            return true;
        }
        if (SystemInfo.isJdk15Above() || SystemInfo.isCJKLocale()) {
            return true;
        }
        String systemFonts = null;
        try {
            systemFonts = (String)AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        boolean bl = useSystemFontSettings = systemFonts != null && Boolean.valueOf(systemFonts) != false;
        if (useSystemFontSettings) {
            Object value = UIDefaultsLookup.get("Application.useSystemFontSettings");
            useSystemFontSettings = value != null || Boolean.TRUE.equals(value);
        }
        return "true".equals(SecurityUtils.getProperty("defaultFont", "false")) || useSystemFontSettings;
    }

    public static void printUIDefaults() {
        Enumeration e = UIManager.getDefaults().keys();
        ArrayList<String> list = new ArrayList<String>();
        System.out.println("Non-string keys ---");
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key instanceof String) {
                list.add((String)key);
                continue;
            }
            System.out.println(key + " => " + UIDefaultsLookup.get(key));
        }
        System.out.println();
        Object[] array = list.toArray(new String[list.size()]);
        Arrays.sort(array);
        System.out.println("String keys ---");
        for (Object key : array) {
            System.out.println(key + " => " + UIDefaultsLookup.get(key));
        }
    }

    public static void setRecursively(Component c, Handler handler) {
        JideSwingUtilities.setRecursively0(c, handler);
        handler.postAction(c);
    }

    private static void setRecursively0(Component c, Handler handler) {
        if (handler.condition(c)) {
            handler.action(c);
        }
        if (handler instanceof ConditionHandler && ((ConditionHandler)handler).stopCondition(c)) {
            return;
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)c;
            children = new Component[tabbedPane.getTabCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = tabbedPane.getComponentAt(i);
            }
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                JideSwingUtilities.setRecursively0(child, handler);
            }
        }
    }

    public static Component getRecursively(Component c, GetHandler handler) {
        return JideSwingUtilities.getRecursively0(c, handler);
    }

    private static Component getRecursively0(Component c, GetHandler handler) {
        if (handler.condition(c)) {
            return handler.action(c);
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                Component result = JideSwingUtilities.getRecursively0(child, handler);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static void setEnabledRecursively(Component c, final boolean enabled) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return true;
            }

            public void action(Component c) {
                c.setEnabled(enabled);
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void putClientPropertyRecursively(Component c, final String clientProperty, final Object value) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return c instanceof JComponent;
            }

            public void action(Component c) {
                ((JComponent)c).putClientProperty(clientProperty, value);
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void setRequestFocusEnabledRecursively(Component c, final boolean enabled) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return true;
            }

            public void action(Component c) {
                if (c instanceof JComponent) {
                    ((JComponent)c).setRequestFocusEnabled(enabled);
                }
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void setOpaqueRecursively(Component c, final boolean opaque) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return !(c instanceof JComboBox) && !(c instanceof JButton) && !(c instanceof JTextComponent) && !(c instanceof ListCellRenderer) && !(c instanceof TreeCellRenderer) && !(c instanceof TableCellRenderer) && !(c instanceof CellEditor);
            }

            public void action(Component c) {
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    if (Boolean.TRUE.equals(jc.getClientProperty(JideSwingUtilities.SET_OPAQUE_RECURSIVELY_EXCLUDED))) {
                        return;
                    }
                    jc.setOpaque(opaque);
                    if (jc.getClientProperty(JideSwingUtilities.OPAQUE_LISTENER) == null) {
                        if (opaque) {
                            if (_setOpaqueTrueListener == null) {
                                _setOpaqueTrueListener = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if (evt.getSource() instanceof JComponent) {
                                            Component component = (Component)evt.getSource();
                                            component.removePropertyChangeListener("opaque", this);
                                            if (component instanceof JComponent) {
                                                ((JComponent)component).setOpaque(true);
                                            }
                                            component.addPropertyChangeListener("opaque", this);
                                        }
                                    }
                                };
                            }
                            jc.addPropertyChangeListener("opaque", _setOpaqueTrueListener);
                            jc.putClientProperty("opaqueListener", _setOpaqueTrueListener);
                        } else {
                            if (_setOpaqueFalseListener == null) {
                                _setOpaqueFalseListener = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if (evt.getSource() instanceof JComponent && evt.getSource() instanceof JComponent) {
                                            Component component = (Component)evt.getSource();
                                            component.removePropertyChangeListener("opaque", this);
                                            if (component instanceof JComponent) {
                                                ((JComponent)component).setOpaque(false);
                                            }
                                            component.addPropertyChangeListener("opaque", this);
                                        }
                                    }
                                };
                            }
                            jc.addPropertyChangeListener("opaque", _setOpaqueFalseListener);
                            jc.putClientProperty(JideSwingUtilities.OPAQUE_LISTENER, _setOpaqueFalseListener);
                        }
                    }
                }
            }

            public void postAction(Component c) {
            }
        });
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap, boolean isHorizontal) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        JideSwingUtilities.layoutCompoundLabel(b, fm, text, icon, isHorizontal, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return JideSwingUtilities.layoutCompoundLabelImpl(c, fm, text, icon, isHorizontal, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return JideSwingUtilities.layoutCompoundLabelImpl(null, fm, text, icon, isHorizontal, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (isHorizontal) {
            return JideSwingUtilities.layoutCompoundLabelImplHorizontal(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
        }
        return JideSwingUtilities.layoutCompoundLabelImplVertical(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String getMaxLengthWord(String text) {
        if (text.indexOf(32) == -1) {
            return text;
        }
        int minDiff = text.length();
        int minPos = -1;
        int mid = text.length() / 2;
        int pos = -1;
        while ((pos = text.indexOf(32, pos + 1)) != -1) {
            int diff = Math.abs(pos - mid);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minPos = pos;
        }
        return minPos >= mid ? text.substring(0, minPos) : text.substring(minPos + 1);
    }

    private static String layoutCompoundLabelImplHorizontal(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text);
                textR.height = fm.getHeight();
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap))) {
            if (v != null) {
                textR.width = availTextWidth;
            } else {
                int nChars;
                String clipString = "...";
                int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
                for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
                }
                text = text.substring(0, nChars) + clipString;
                textR.width = SwingUtilities.computeStringWidth(fm, text);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? (iconR.height >> 1) - (textR.height >> 1) : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? (iconR.width >> 1) - (textR.width >> 1) : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + (viewR.height >> 1) - (labelR_y + (labelR_height >> 1)) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + (viewR.width >> 1) - (labelR_x + (labelR_width >> 1)));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return text;
    }

    private static String layoutCompoundLabelImplVertical(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int dIcony;
        int dy;
        int availTextHeight;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.height = (int)v.getPreferredSpan(0);
                textR.width = (int)v.getPreferredSpan(1);
            } else {
                textR.height = SwingUtilities.computeStringWidth(fm, text);
                textR.width = fm.getHeight();
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.height > (availTextHeight = horizontalTextPosition == 0 ? viewR.height : viewR.height - (iconR.height + gap))) {
            if (v != null) {
                textR.height = availTextHeight;
            } else {
                int nChars;
                String clipString = "...";
                int totalHeight = SwingUtilities.computeStringWidth(fm, clipString);
                for (nChars = 0; nChars < text.length() && (totalHeight += fm.charWidth(text.charAt(nChars))) <= availTextHeight; ++nChars) {
                }
                text = text.substring(0, nChars) + clipString;
                textR.height = SwingUtilities.computeStringWidth(fm, text);
            }
        }
        if (verticalTextPosition == 1) {
            textR.x = horizontalTextPosition != 0 ? 0 : -(textR.width + gap);
        } else if (verticalTextPosition == 0) {
            textR.y = (iconR.width >> 1) - (textR.width >> 1);
        } else {
            textR.x = horizontalTextPosition != 0 ? iconR.width - textR.width : iconR.width + gap;
        }
        textR.y = horizontalTextPosition == 2 ? -(textR.height + gap) : (horizontalTextPosition == 0 ? (iconR.height >> 1) - (textR.height >> 1) : iconR.height + gap);
        int labelR_x = Math.min(iconR.y, textR.y);
        int labelR_width = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_x;
        int labelR_y = Math.min(iconR.x, textR.x);
        int labelR_height = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_y;
        if (verticalAlignment == 1) {
            dy = viewR.x - labelR_y;
            dIcony = viewR.x + viewR.width - (labelR_y + labelR_height);
        } else if (verticalAlignment == 0) {
            dIcony = dy = viewR.x + (viewR.width >> 1) - (labelR_y + (labelR_height >> 1));
        } else {
            dy = viewR.x + viewR.width - (labelR_y + labelR_height);
            dIcony = viewR.x - labelR_y;
        }
        int dx = horizontalAlignment == 2 ? viewR.y - labelR_x : (horizontalAlignment == 4 ? viewR.y + viewR.height - (labelR_x + labelR_width) : viewR.y + (viewR.height >> 1) - (labelR_x + (labelR_width >> 1)));
        textR.y += dx;
        textR.x += dy;
        iconR.y += dx;
        iconR.x += dIcony;
        return text;
    }

    public static int getOrientationOf(Component component) {
        Integer value;
        if (component instanceof Alignable) {
            return ((Alignable)((Object)component)).getOrientation();
        }
        if (component instanceof JComponent && (value = (Integer)((JComponent)component).getClientProperty("orientation")) != null) {
            return value;
        }
        return 0;
    }

    public static void setOrientationOf(Component component, int orientation) {
        int old = JideSwingUtilities.getOrientationOf(component);
        if (orientation != old) {
            if (component instanceof Alignable) {
                ((Alignable)((Object)component)).setOrientation(orientation);
            } else if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("orientation", orientation);
            }
        }
    }

    public static void setChildrenOrientationOf(Container c, int orientation) {
        Component[] components;
        for (Component component : components = c.getComponents()) {
            JideSwingUtilities.setOrientationOf(component, orientation);
        }
    }

    public static Map<Component, Boolean> disableDoubleBuffered(Component c) {
        final HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        if (c instanceof JComponent) {
            JideSwingUtilities.setRecursively(c, new Handler(){

                public boolean condition(Component c) {
                    return c instanceof JComponent && c.isDoubleBuffered();
                }

                public void action(Component c) {
                    map.put(c, Boolean.TRUE);
                    ((JComponent)c).setDoubleBuffered(false);
                }

                public void postAction(Component c) {
                }
            });
        }
        return map;
    }

    public static Map<Component, Boolean> enableDoubleBuffered(Component c) {
        final HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        if (c instanceof JComponent) {
            JideSwingUtilities.setRecursively(c, new Handler(){

                public boolean condition(Component c) {
                    return c instanceof JComponent && !c.isDoubleBuffered();
                }

                public void action(Component c) {
                    map.put(c, Boolean.FALSE);
                    ((JComponent)c).setDoubleBuffered(true);
                }

                public void postAction(Component c) {
                }
            });
        }
        return map;
    }

    public static void restoreDoubleBuffered(Component c, final Map<Component, Boolean> map) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return c instanceof JComponent;
            }

            public void action(Component c) {
                Boolean value = (Boolean)map.get(c);
                if (value != null) {
                    ((JComponent)c).setDoubleBuffered(Boolean.TRUE.equals(value));
                }
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void paintBackground(Graphics g, Rectangle rect, Color border, Color bk) {
        Color old = g.getColor();
        g.setColor(bk);
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g.setColor(border);
        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g.setColor(old);
    }

    public static void paintBackground(Graphics2D g2d, Rectangle rect, Color border, Paint paint) {
        Color old = g2d.getColor();
        g2d.setPaint(paint);
        g2d.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g2d.setColor(border);
        g2d.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g2d.setColor(old);
    }

    private static boolean drawTextAntialiased(Component c) {
        if (!AA_TEXT_DEFINED) {
            if (c != null) {
                if (c instanceof JComponent) {
                    Boolean aaProperty = (Boolean)((JComponent)c).getClientProperty(AA_TEXT_PROPERTY_KEY);
                    return aaProperty != null ? aaProperty : false;
                }
                return false;
            }
            return false;
        }
        return AA_TEXT;
    }

    public static boolean drawTextAntialiased(boolean aaText) {
        if (!AA_TEXT_DEFINED) {
            return aaText;
        }
        return AA_TEXT;
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        JideSwingUtilities.drawString(c, g, text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }

    private static RenderingHints getRenderingHints(Graphics2D g2d, RenderingHints hintsToSave, RenderingHints savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave == null || hintsToSave.size() == 0) {
            return savedHints;
        }
        Set<Object> objects = hintsToSave.keySet();
        for (Object o : objects) {
            RenderingHints.Key key = (RenderingHints.Key)o;
            Object value = g2d.getRenderingHint(key);
            savedHints.put(key, value);
        }
        return savedHints;
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        if (SystemInfo.isJdk6Above()) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints oldHints = null;
            if (renderingHints != null) {
                oldHints = JideSwingUtilities.getRenderingHints(g2d, renderingHints, null);
                g2d.addRenderingHints(renderingHints);
            }
            g2d.drawString(text, x, y);
            if (oldHints != null) {
                g2d.addRenderingHints(oldHints);
            }
        } else if (JideSwingUtilities.drawTextAntialiased(c) && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.drawString(text, x, y);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            g.drawString(text, x, y);
        }
    }

    public static Object setupAntialiasing(Component c, Graphics g) {
        Object oldHints;
        Graphics2D g2d = (Graphics2D)g;
        if (SystemInfo.isJdk6Above()) {
            oldHints = JideSwingUtilities.getRenderingHints(g2d, renderingHints, null);
            if (renderingHints != null) {
                g2d.addRenderingHints(renderingHints);
            }
        } else {
            oldHints = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JideSwingUtilities.drawTextAntialiased(c)) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return oldHints;
    }

    public static void restoreAntialiasing(Component c, Graphics g, Object oldHints) {
        Graphics2D g2d = (Graphics2D)g;
        if (SystemInfo.isJdk6Above()) {
            if (oldHints != null) {
                g2d.addRenderingHints((RenderingHints)oldHints);
            }
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHints);
        }
    }

    public static Object setupShapeAntialiasing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldHints = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return oldHints;
    }

    public static void restoreShapeAntialiasing(Graphics g, Object oldHints) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints);
    }

    public static void drawGrip(Graphics g, Rectangle rectangle, int maxLength, int maxThickness) {
        JideSwingUtilities.drawGrip(g, rectangle, maxLength, maxThickness, true);
    }

    public static void drawGrip(Graphics g, Rectangle rectangle, int maxLength, int maxThickness, boolean isSelected) {
        if (rectangle.width > rectangle.height) {
            int count = maxLength;
            if (maxLength * 3 > rectangle.width) {
                count = rectangle.width / 3;
            }
            int startX = rectangle.x + (rectangle.width - count * 3 >> 1);
            int startY = rectangle.y + (rectangle.height - maxThickness * 3 >> 1);
            for (int i = 0; i < maxThickness; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (isSelected) {
                        g.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        g.drawLine(startX + j * 3, startY + i * 3, startX + j * 3, startY + i * 3);
                    }
                    g.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    g.drawLine(startX + j * 3 + 1, startY + i * 3 + 1, startX + j * 3 + 1, startY + i * 3 + 1);
                }
            }
        } else {
            int count = maxLength;
            if (maxLength * 3 > rectangle.height) {
                count = rectangle.height / 3;
            }
            int startX = rectangle.x + (rectangle.width - maxThickness * 3 >> 1);
            int startY = rectangle.y + (rectangle.height - count * 3 >> 1);
            for (int i = 0; i < maxThickness; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (isSelected) {
                        g.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        g.drawLine(startX + i * 3, startY + j * 3, startX + i * 3, startY + j * 3);
                    }
                    g.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    g.drawLine(startX + i * 3 + 1, startY + j * 3 + 1, startX + i * 3 + 1, startY + j * 3 + 1);
                }
            }
        }
    }

    public static void registerTabKey(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }, KeyStroke.getKeyStroke(9, 0), 0);
        } else {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component c = container.getComponent(i);
                if (!(c instanceof JComponent) || !c.isFocusable()) continue;
                ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }, KeyStroke.getKeyStroke(9, 0), 0);
            }
        }
    }

    public static void fillGradient(Graphics g, Rectangle rect, int orientation) {
        Graphics2D g2d = (Graphics2D)g;
        Color col1 = new Color(255, 255, 255, 0);
        Color col2 = new Color(255, 255, 255, 48);
        Color col3 = new Color(0, 0, 0, 0);
        Color col4 = new Color(0, 0, 0, 32);
        if (orientation == 0) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height >> 1), col2, col1, true);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y + (rect.height >> 1), rect.width, rect.height >> 1), col3, col4, true);
        } else {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width >> 1, rect.height), col2, col1, false);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x + (rect.width >> 1), rect.y, rect.width >> 1, rect.height), col3, col4, false);
        }
    }

    public static void fillSingleGradient(Graphics g, Rectangle rect, int orientation) {
        JideSwingUtilities.fillSingleGradient(g, rect, orientation, 127);
    }

    public static void fillSingleGradient(Graphics g, Rectangle rect, int orientation, int level) {
        Graphics2D g2d = (Graphics2D)g;
        Color col1 = new Color(255, 255, 255, 0);
        Color col2 = new Color(255, 255, 255, level);
        if (orientation == 5) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col2, col1, true);
        } else if (orientation == 1) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col1, col2, true);
        } else if (orientation == 3) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col2, col1, false);
        } else if (orientation == 7) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col1, col2, false);
        }
    }

    public static Paint getRadialGradientPaint(Point2D point, float radius, float[] fractions, Color[] colors) {
        Class<?> radialGradientPaintClass = null;
        try {
            radialGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (radialGradientPaintClass != null) {
            try {
                if (_radialGradientPaintConstructor2 == null) {
                    _radialGradientPaintConstructor2 = radialGradientPaintClass.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
                }
                Object radialGradientPaint = _radialGradientPaintConstructor2.newInstance(point, Float.valueOf(radius), fractions, colors);
                return (Paint)radialGradientPaint;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colors[0];
    }

    public static Paint getRadialGradientPaint(float cx, float cy, float radius, float[] fractions, Color[] colors) {
        if (_radialGradientPaintClass == null) {
            try {
                _radialGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
        }
        if (_radialGradientPaintClass != null) {
            try {
                if (_radialGradientPaintConstructor1 == null) {
                    _radialGradientPaintConstructor1 = _radialGradientPaintClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object radialGradientPaint = _radialGradientPaintConstructor1.newInstance(Float.valueOf(cx), Float.valueOf(cy), Float.valueOf(radius), fractions, colors);
                return (Paint)radialGradientPaint;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colors[0];
    }

    public static Paint getLinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        if (_linearGradientPaintClass == null) {
            try {
                _linearGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.LinearGradientPaint") : Class.forName("org.apache.batik.ext.awt.LinearGradientPaint");
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
        }
        if (_linearGradientPaintClass != null) {
            try {
                if (_linearGradientPaintConstructor1 == null) {
                    _linearGradientPaintConstructor1 = _linearGradientPaintClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object linearGradientPaint = _linearGradientPaintConstructor1.newInstance(Float.valueOf(startX), Float.valueOf(startY), Float.valueOf(endX), Float.valueOf(endY), fractions, colors);
                return (Paint)linearGradientPaint;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        System.err.println("Warning - linear gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colors[0];
    }

    public static boolean containerContainsFocus(Container cont) {
        boolean focusOwned;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component permFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl = focusOwned = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, cont);
        if (!focusOwned) {
            focusOwned = permFocusOwner != null && SwingUtilities.isDescendingFrom(permFocusOwner, cont);
        }
        return focusOwned;
    }

    public static boolean componentIsPermanentFocusOwner(Component comp) {
        return comp != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == comp;
    }

    public static void installColorsAndFont(Component c, Color background, Color foreground, Font font) {
        JideSwingUtilities.installFont(c, font);
        JideSwingUtilities.installColors(c, background, foreground);
    }

    public static void installFont(Component c, Font font) {
        Font f = c.getFont();
        if (f == null || f instanceof UIResource) {
            c.setFont(font);
        }
    }

    public static void installColors(Component c, Color background, Color foreground) {
        Color bg = c.getBackground();
        if (background != null && (bg == null || bg instanceof UIResource)) {
            c.setBackground(background);
        }
        Color fg = c.getForeground();
        if (foreground != null && (fg == null || fg instanceof UIResource)) {
            c.setForeground(foreground);
        }
    }

    public static void installBorder(JComponent c, Border defaultBorder) {
        Border border = c.getBorder();
        if (border == null || border instanceof UIResource) {
            c.setBorder(defaultBorder);
        }
    }

    public static void fillNormalGradient(Graphics2D g2d, Shape s, Color startColor, Color endColor, boolean isVertical) {
        Rectangle rect = s.getBounds();
        GradientPaint paint = isVertical ? new GradientPaint(rect.x, rect.y, startColor, rect.x, rect.height + rect.y, endColor, true) : new GradientPaint(rect.x, rect.y, startColor, rect.width + rect.x, rect.y, endColor, true);
        Paint old = g2d.getPaint();
        g2d.setPaint(paint);
        g2d.fill(s);
        g2d.setPaint(old);
    }

    public static void fillGradient(Graphics2D g2d, Shape s, Color startColor, Color endColor, boolean isVertical) {
        if ("true".equals(SecurityUtils.getProperty("normalGradientPaint", "false"))) {
            JideSwingUtilities.fillNormalGradient(g2d, s, startColor, endColor, isVertical);
        } else {
            FastGradientPainter.drawGradient(g2d, s, startColor, endColor, isVertical);
        }
    }

    public static void clearGradientCache() {
        FastGradientPainter.clearGradientCache();
    }

    public static Window getTopModalDialog(Window w) {
        Window[] ws;
        for (Window w1 : ws = w.getOwnedWindows()) {
            if (!w1.isVisible() || !(w1 instanceof Dialog) || !((Dialog)w1).isModal()) continue;
            return JideSwingUtilities.getTopModalDialog(w1);
        }
        return w;
    }

    public static void traceFocus() {
        JideSwingUtilities.traceFocus(false);
    }

    public static void traceFocus(final boolean useBorders) {
        if (tracingFocus) {
            return;
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String newName;
                String oldName;
                if (useBorders) {
                    Component newValue;
                    Border oldBorder;
                    Component oldValue = (Component)evt.getOldValue();
                    if (oldValue instanceof JComponent && (oldBorder = ((JComponent)oldValue).getBorder()) instanceof TraceDebugBorder) {
                        ((JComponent)oldValue).setBorder(((TraceDebugBorder)oldBorder).getInsideBorder());
                    }
                    if ((newValue = (Component)evt.getNewValue()) instanceof JComponent) {
                        Border oldBorder2 = ((JComponent)newValue).getBorder();
                        if (oldBorder2 == null) {
                            oldBorder2 = new EmptyBorder(0, 0, 0, 0);
                        }
                        if (!(oldBorder2 instanceof TraceDebugBorder)) {
                            ((JComponent)newValue).setBorder(new TraceDebugBorder(oldBorder2));
                        }
                    }
                }
                String string = oldName = evt.getOldValue() == null ? "null" : evt.getOldValue().getClass().getName();
                if (evt.getOldValue() instanceof Component && ((Component)evt.getOldValue()).getName() != null) {
                    oldName = oldName + "'" + ((Component)evt.getOldValue()).getName() + "'";
                }
                String string2 = newName = evt.getNewValue() == null ? "null" : evt.getNewValue().getClass().getName();
                if (evt.getNewValue() instanceof Component && ((Component)evt.getNewValue()).getName() != null) {
                    newName = newName + "'" + ((Component)evt.getNewValue()).getName() + "'";
                }
                System.out.println(evt.getPropertyName() + ": " + oldName + " ==> " + newName);
            }
        };
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", listener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", listener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", listener);
        tracingFocus = true;
    }

    public static void runGCAndPrintFreeMemory() {
        DecimalFormat memFormatter = new DecimalFormat("###,###,##0.####");
        String memFree = memFormatter.format(Runtime.getRuntime().freeMemory() / 1024L);
        String memTotal = memFormatter.format(Runtime.getRuntime().totalMemory() / 1024L);
        String memUsed = memFormatter.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("before gc: (Total [" + memTotal + "k] - Free [" + memFree + "k]) = Used [" + memUsed + "k]");
        System.runFinalization();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        memFree = memFormatter.format(Runtime.getRuntime().freeMemory() / 1024L);
        memTotal = memFormatter.format(Runtime.getRuntime().totalMemory() / 1024L);
        memUsed = memFormatter.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("after gc: (Total [" + memTotal + "k] - Free [" + memFree + "k]) = Used [" + memUsed + "k]");
    }

    public static JPanel createTableModelModifier(final DefaultTableModel tableModel) {
        JPanel tableModelPanel = new JPanel(new BorderLayout(6, 6));
        final JTable table = new JTable(tableModel);
        tableModelPanel.add(new JScrollPane(table));
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton insert = new JButton("Insert");
        insert.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Vector<Vector> rowData = tableModel.getDataVector();
                int index = table.getSelectedRow();
                if (index != -1) {
                    Vector v = rowData.get(index);
                    Vector<Object> clone = new Vector<Object>();
                    for (int i = 0; i < v.size(); ++i) {
                        if (i == 0) {
                            clone.add((int)(Math.random() * 10.0));
                            continue;
                        }
                        clone.add("" + v.get(i));
                    }
                    tableModel.insertRow(index, clone);
                }
            }
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    int row = rows[i];
                    tableModel.removeRow(row);
                }
            }
        });
        JButton clear = new JButton("Clear");
        clear.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    tableModel.removeRow(0);
                }
            }
        });
        buttonPanel.add(insert);
        buttonPanel.add(delete);
        buttonPanel.add(clear);
        tableModelPanel.add((Component)buttonPanel, "Last");
        return tableModelPanel;
    }

    public static Component findSomethingFocusable(Container container) {
        Component[] comps;
        if (JideSwingUtilities.passesFocusabilityTest(container)) {
            container.requestFocusInWindow();
            return container;
        }
        for (Component comp1 : comps = container.getComponents()) {
            Component comp;
            if (JideSwingUtilities.passesFocusabilityTest(comp1)) {
                container.requestFocusInWindow();
                return container;
            }
            if (!(comp1 instanceof Container) || (comp = JideSwingUtilities.findSomethingFocusable((Container)comp1)) == null) continue;
            return comp;
        }
        return null;
    }

    public static boolean passesFocusabilityTest(Component comp) {
        return comp != null && comp.isEnabled() && comp.isDisplayable() && comp.isVisible() && comp.isFocusable() && comp.isShowing();
    }

    public static void ignoreException(Exception e) {
    }

    public static void printException(Exception e) {
        System.err.println(e.getLocalizedMessage());
    }

    public static void throwException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static void throwInvocationTargetException(InvocationTargetException e) {
        if (e.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e.getTargetException();
        }
        if (e.getTargetException() instanceof Error) {
            throw (Error)e.getTargetException();
        }
        throw new RuntimeException(e.getTargetException());
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Component getDescendantOfClass(Class c, Container container) {
        Component[] components;
        if (container == null || c == null) {
            return null;
        }
        for (Component component : components = container.getComponents()) {
            Component found;
            if (c.isInstance(component)) {
                return component;
            }
            if (!(component instanceof Container) || (found = JideSwingUtilities.getDescendantOfClass(c, (Container)component)) == null) continue;
            return found;
        }
        return null;
    }

    public static float getDefaultFontSize() {
        String fontSize = SecurityUtils.getProperty("jide.fontSize", null);
        float defaultFontSize = -1.0f;
        try {
            if (fontSize != null) {
                defaultFontSize = Float.parseFloat(fontSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultFontSize;
    }

    public static Object getMenuFont(Toolkit toolkit, UIDefaults table) {
        Font font;
        Object menuFont = null;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        menuFont = JideSwingUtilities.shouldUseSystemFont() ? (defaultFontSize == -1.0f ? table.getFont("ToolBar.font") : new WindowsDesktopProperty("win.menu.font", table.getFont("ToolBar.font"), toolkit, defaultFontSize)) : ((font = table.getFont("ToolBar.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 0, defaultFontSize != -1.0f ? (int)defaultFontSize : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 0, defaultFontSize != -1.0f ? (int)defaultFontSize : font.getSize()));
        if (menuFont == null) {
            return JideSwingUtilities.getControlFont(toolkit, table);
        }
        return menuFont;
    }

    public static Object getControlFont(Toolkit toolkit, UIDefaults table) {
        Object controlFont;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = table.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            controlFont = defaultFontSize == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize);
        } else {
            Font font = table.getFont("Label.font");
            controlFont = font == null ? SecurityUtils.createFontUIResource("Tahoma", 0, defaultFontSize != -1.0f ? (int)defaultFontSize : 11) : (defaultFontSize == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize));
        }
        return controlFont;
    }

    public static Object getBoldFont(Toolkit toolkit, UIDefaults table) {
        Object boldFont;
        if (SystemInfo.isCJKLocale()) {
            return JideSwingUtilities.getControlFont(toolkit, table);
        }
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = table.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            boldFont = defaultFontSize == -1.0f ? new FontUIResource(font.deriveFont(1)) : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize, 1);
        } else {
            Font font = table.getFont("Label.font");
            boldFont = font == null ? SecurityUtils.createFontUIResource("Tahoma", 1, defaultFontSize != -1.0f ? (int)defaultFontSize : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 1, defaultFontSize != -1.0f ? (int)defaultFontSize : font.getSize());
        }
        return boldFont;
    }

    public static void drawShadow(Graphics g, Component c, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        ShadowFactory factory = new ShadowFactory(6, 0.7f, Color.GRAY);
        BufferedImage temp = new BufferedImage(w, h, 2);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
        g2.dispose();
        BufferedImage shadow = factory.createShadow(temp);
        g.drawImage(shadow, x, y, c);
    }

    public static void drawImageBorder(Graphics g, ImageIcon img, Rectangle rect, Insets ins, boolean drawCenter) {
        int left = ins.left;
        int right = ins.right;
        int top = ins.top;
        int bottom = ins.bottom;
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        g.drawImage(img.getImage(), x, y, x + left, y + top, 0, 0, left, top, null);
        g.drawImage(img.getImage(), x + left, y, x + w - right, y + top, left, 0, img.getIconWidth() - right, top, null);
        g.drawImage(img.getImage(), x + w - right, y, x + w, y + top, img.getIconWidth() - right, 0, img.getIconWidth(), top, null);
        g.drawImage(img.getImage(), x, y + top, x + left, y + h - bottom, 0, top, left, img.getIconHeight() - bottom, null);
        g.drawImage(img.getImage(), x + left, y + top, x + w - right, y + h - bottom, left, top, img.getIconWidth() - right, img.getIconHeight() - bottom, null);
        g.drawImage(img.getImage(), x + w - right, y + top, x + w, y + h - bottom, img.getIconWidth() - right, top, img.getIconWidth(), img.getIconHeight() - bottom, null);
        g.drawImage(img.getImage(), x, y + h - bottom, x + left, y + h, 0, img.getIconHeight() - bottom, left, img.getIconHeight(), null);
        g.drawImage(img.getImage(), x + left, y + h - bottom, x + w - right, y + h, left, img.getIconHeight() - bottom, img.getIconWidth() - right, img.getIconHeight(), null);
        g.drawImage(img.getImage(), x + w - right, y + h - bottom, x + w, y + h, img.getIconWidth() - right, img.getIconHeight() - bottom, img.getIconWidth(), img.getIconHeight(), null);
        if (drawCenter) {
            g.drawImage(img.getImage(), x + left, y + top, x + w - right, y + h - bottom, left, top, img.getIconWidth() - right, img.getIconHeight() - bottom, null);
        }
    }

    public static boolean compositeRequestFocus(Component component) {
        LOGGER_FOCUS.fine("compositeRequestFocus " + component);
        if (component instanceof Container) {
            Container rootAncestor;
            LOGGER_FOCUS.fine("compositeRequestFocus is container.");
            Container container = (Container)component;
            if (container.isFocusCycleRoot()) {
                LOGGER_FOCUS.fine("compositeRequestFocus is focuscycleroot.");
                FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
                Component comp = policy.getDefaultComponent(container);
                LOGGER_FOCUS.fine("compositeRequestFocus default component = " + comp);
                if (comp != null && comp.isShowing() && container.getComponentCount() > 0) {
                    LOGGER_FOCUS.fine("compositeRequestFocus default component passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest(comp));
                    LOGGER_FOCUS.fine("compositeRequestFocus requestFocus for " + comp);
                    comp.requestFocus();
                    return true;
                }
            }
            if ((rootAncestor = container.getFocusCycleRootAncestor()) != null) {
                LOGGER_FOCUS.fine("compositeRequestFocus using rootAncestor =" + rootAncestor);
                FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
                Component comp = null;
                try {
                    comp = policy.getComponentAfter(rootAncestor, container);
                }
                catch (Exception e) {
                    // empty catch block
                }
                LOGGER_FOCUS.fine("compositeRequestFocus getComponentAfter =" + comp);
                if (comp != null && SwingUtilities.isDescendingFrom(comp, container)) {
                    LOGGER_FOCUS.fine("compositeRequestFocus getComponentAfter passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest(comp));
                    LOGGER_FOCUS.fine("compositeRequestFocus requestFocus for " + comp);
                    comp.requestFocus();
                    return true;
                }
            }
        }
        if (!JideSwingUtilities.passesFocusabilityTest(component)) {
            LOGGER_FOCUS.fine("compositeRequestFocus returingfalse because !passesFocusabilityTest" + component);
            return false;
        }
        LOGGER_FOCUS.fine("compositeRequestFocus component=" + component);
        component.requestFocus();
        return true;
    }

    public static boolean isAncestorOfFocusOwner(Component component) {
        boolean hasFocus = false;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == focusOwner || component instanceof Container && ((Container)component).isAncestorOf(focusOwner)) {
            hasFocus = true;
        }
        return hasFocus;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JideSwingUtilities.getWindowForComponent(parentComponent.getParent());
    }

    public static boolean isKeyListenerRegistered(Component component, KeyListener l) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = component.getKeyListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static void insertKeyListener(Component component, KeyListener l, int index) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = component.getKeyListeners()) {
            component.removeKeyListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            KeyListener listener = listeners[i];
            if (index == i) {
                component.addKeyListener(l);
            }
            component.addKeyListener(listener);
        }
        if (index > listeners.length - 1) {
            component.addKeyListener(l);
        }
    }

    public static void insertTableModelListener(TableModel model, TableModelListener l, int index) {
        TableModelListener[] listeners;
        if (!(model instanceof AbstractTableModel)) {
            model.addTableModelListener(l);
            return;
        }
        for (TableModelListener listener : listeners = ((AbstractTableModel)model).getTableModelListeners()) {
            model.removeTableModelListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            TableModelListener listener = listeners[i];
            if (index == i) {
                model.addTableModelListener(l);
            }
            model.addTableModelListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            model.addTableModelListener(l);
        }
    }

    public static boolean isPropertyChangeListenerRegistered(Component component, PropertyChangeListener l) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = component.getPropertyChangeListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseListenerRegistered(Component component, MouseListener l) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseListener(Component component, MouseListener l, int index) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            component.removeMouseListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            MouseListener listener = listeners[i];
            if (index == i) {
                component.addMouseListener(l);
            }
            component.addMouseListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseListener(l);
        }
    }

    public static boolean isMouseMotionListenerRegistered(Component component, MouseMotionListener l) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = component.getMouseMotionListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseMotionListener(Component component, MouseMotionListener l, int index) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = component.getMouseMotionListeners()) {
            component.removeMouseMotionListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            MouseMotionListener listener = listeners[i];
            if (index == i) {
                component.addMouseMotionListener(l);
            }
            component.addMouseMotionListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseMotionListener(l);
        }
    }

    public static Component getScrollPane(Component innerComponent) {
        Component component = innerComponent;
        if (innerComponent instanceof JScrollPane) {
            return innerComponent;
        }
        if (component.getParent() != null && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
            component = component.getParent().getParent();
            return component;
        }
        return null;
    }

    public static boolean isListenerRegistered(EventListenerList list, Class t, EventListener l) {
        Object[] objects = list.getListenerList();
        return JideSwingUtilities.isListenerRegistered(objects, t, l);
    }

    public static boolean isListenerRegistered(Component component, Class t, EventListener l) {
        Object[] objects = component.getListeners(t);
        return JideSwingUtilities.isListenerRegistered(objects, t, l);
    }

    private static boolean isListenerRegistered(Object[] objects, Class t, EventListener l) {
        for (int i = objects.length - 2; i >= 0; i -= 2) {
            if (objects[i] != t || !objects[i + 1].equals(l)) continue;
            return true;
        }
        return false;
    }

    public static Component getFirstChildOf(final Class<?> clazz, Component c) {
        return JideSwingUtilities.getRecursively(c, new GetHandler(){

            public boolean condition(Component c) {
                return clazz.isAssignableFrom(c.getClass());
            }

            public Component action(Component c) {
                return c;
            }
        });
    }

    public static int getComponentIndex(Container container, Component c) {
        if (c.getParent() != container) {
            return -1;
        }
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static Vector convertDefaultComboBoxModelToVector(DefaultComboBoxModel model) {
        Vector v = new Vector();
        for (int i = 0; i < model.getSize(); ++i) {
            v.add(model.getElementAt(i));
        }
        return v;
    }

    public static void ensureRowVisible(JTable table, int row) {
        Rectangle rScrollTo;
        Rectangle r = table.getVisibleRect();
        Rectangle rMid = table.getCellRect(row, 0, true);
        Rectangle rBefore = null;
        Rectangle rAfter = null;
        if (row < table.getModel().getRowCount() - 1) {
            rAfter = table.getCellRect(row + 1, 0, true);
        }
        if (row > 0) {
            rBefore = table.getCellRect(row - 1, 0, true);
        }
        int yLow = (int)rMid.getMinY();
        int yHi = (int)rMid.getMaxY();
        int xLow = r.x;
        int xHi = r.x + r.width;
        if (rBefore != null) {
            yLow = (int)rBefore.getMinY();
        }
        if (rAfter != null) {
            yHi = (int)rAfter.getMaxY();
        }
        if (!r.contains(rScrollTo = new Rectangle(xLow, yLow, xHi - xLow, yHi - yLow)) && rScrollTo.height != 0) {
            table.scrollRectToVisible(rScrollTo);
        }
    }

    public static void retargetMouseEvent(int id, MouseEvent e, Component target) {
        if (target == null || target == e.getSource() && id == e.getID()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), target);
        MouseEvent retargeted = new MouseEvent(target, id, e.getWhen(), e.getModifiersEx() | e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
        target.dispatchEvent(retargeted);
    }

    public static JRootPane getOutermostRootPane(Component c) {
        if (c instanceof RootPaneContainer && c.getParent() == null) {
            return ((RootPaneContainer)((Object)c)).getRootPane();
        }
        while (c != null) {
            if (c instanceof JRootPane) {
                JRootPane lastRootPane = (JRootPane)c;
                if (c.getParent().getParent() == null) {
                    return lastRootPane;
                }
                if (c.getParent() instanceof JDialog || c.getParent() instanceof JWindow || c.getParent() instanceof JFrame || c.getParent() instanceof JApplet) {
                    return lastRootPane;
                }
                c = c.getParent().getParent();
            }
            c = SwingUtilities.getRootPane(c);
        }
        return null;
    }

    public static boolean isFixedWidthFont(String fontName, Component component) {
        if (fontName.endsWith(" Bold") || fontName.endsWith(" ITC") || fontName.endsWith(" MT") || fontName.endsWith(" LET") || fontName.endsWith(".bold") || fontName.endsWith(".italic")) {
            return false;
        }
        try {
            int s2;
            int s1;
            int w2;
            int w1;
            int l2;
            Font font = new Font(fontName, 0, 12);
            if (!font.canDisplay('W')) {
                return false;
            }
            Font boldFont = font.deriveFont(1);
            FontMetrics fm = component.getFontMetrics(font);
            FontMetrics fmBold = component.getFontMetrics(boldFont);
            int l1 = fm.charWidth('l');
            if (l1 == (l2 = fmBold.charWidth('l')) && (w1 = fm.charWidth('W')) == (w2 = fmBold.charWidth('W')) && l1 == w1 && (s1 = fm.charWidth(' ')) == (s2 = fmBold.charWidth(' '))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void setLocaleRecursively(Component c, final Locale locale) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return true;
            }

            public void action(Component c) {
                c.setLocale(locale);
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void setBounds(Container container, Component component, Rectangle bounds) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(bounds);
        } else {
            Rectangle r = new Rectangle(bounds);
            int w = container.getWidth();
            r.x = w - (bounds.x + bounds.width);
            component.setBounds(r);
        }
    }

    public static void setBounds(Container container, Component component, int x, int y, int width, int height) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(x, y, width, height);
        } else {
            int w = container.getWidth();
            component.setBounds(w - x - width, y, width, height);
        }
    }

    public static void invalidateRecursively(Component c) {
        if (c instanceof JComponent) {
            JideSwingUtilities.setRecursively(c, new Handler(){

                public boolean condition(Component c) {
                    return true;
                }

                public void action(Component c) {
                    if (c instanceof JComponent) {
                        ((JComponent)c).revalidate();
                    }
                    c.invalidate();
                }

                public void postAction(Component c) {
                }
            });
        }
        c.doLayout();
        c.repaint();
    }

    public static void synchronizeKeyboardActions(JComponent sourceComponent, JComponent targetComponent, KeyStroke[] keyStrokes, int condition) {
        for (KeyStroke keyStroke : keyStrokes) {
            ActionListener actionListener = sourceComponent.getActionForKeyStroke(keyStroke);
            if (actionListener == null) continue;
            targetComponent.registerKeyboardAction(actionListener, keyStroke, condition);
        }
    }

    public static JComponent getFirstJComponent(RootPaneContainer rootPaneContainer) {
        return (JComponent)JideSwingUtilities.getRecursively(rootPaneContainer.getContentPane(), new GetHandler(){

            public boolean condition(Component c) {
                return c instanceof JComponent;
            }

            public Component action(Component c) {
                return c;
            }
        });
    }

    public static Dimension adjustPreferredScrollableViewportSize(JList list, Dimension defaultViewportSize) {
        Dimension preferredSize;
        Component c;
        ListCellRenderer<String> renderer;
        Rectangle cellBonds = list.getCellBounds(0, 0);
        if (cellBonds != null && cellBonds.height < 3 && (renderer = list.getCellRenderer()) != null && (c = renderer.getListCellRendererComponent(list, "DUMMY STRING", 0, false, false)) != null && (preferredSize = c.getPreferredSize()) != null) {
            int height = preferredSize.height;
            if (height < 3) {
                try {
                    height = list.getCellBounds((int)1, (int)1).height;
                }
                catch (Exception e) {
                    height = 16;
                }
            }
            list.setFixedCellHeight(height);
        }
        if (SystemInfo.isJdk15Above()) {
            return defaultViewportSize;
        }
        ++defaultViewportSize.height;
        return defaultViewportSize;
    }

    public static void removeFromParentWithFocusTransfer(Component component) {
        boolean wasVisible = component.isVisible();
        component.setVisible(false);
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        component.setVisible(wasVisible);
    }

    public static int getLineHeight(Component c, int defaultHeight) {
        Font f;
        Font font = f = c == null ? null : c.getFont();
        if (f == null) {
            return defaultHeight;
        }
        FontMetrics fm = c.getFontMetrics(f);
        float h = fm.getHeight();
        return (int)(h += (float)fm.getDescent());
    }

    public static void addSeparatorIfNecessary(JPopupMenu popup) {
        int count = popup.getComponentCount();
        if (count > 0 && !(popup.getComponent(count - 1) instanceof JSeparator)) {
            popup.addSeparator();
        }
    }

    public static void setTextComponentTransparent(JTextComponent textComponent) {
        textComponent.setOpaque(false);
        textComponent.putClientProperty("Synthetica.opaque", false);
        textComponent.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        textComponent.putClientProperty("Nimbus.Overrides", new UIDefaults());
    }

    public static int binarySearch(Object[] a, Object key) {
        int x1 = 0;
        int x2 = a.length;
        int i = x2 / 2;
        while (x1 < x2) {
            int c = ((Comparable)a[i]).compareTo(key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * i;
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        String aa = SecurityUtils.getProperty("swing.aatext", "false");
        AA_TEXT_DEFINED = aa != null;
        AA_TEXT = "true".equals(aa);
        renderingHints = null;
        if (SystemInfo.isJdk6Above()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            renderingHints = (RenderingHints)tk.getDesktopProperty("awt.font.desktophints");
            tk.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof RenderingHints) {
                        renderingHints = (RenderingHints)evt.getNewValue();
                    }
                }
            });
        }
        tracingFocus = false;
        Font.getFont("defaultFont");
        Font.getFont("emphasizedFont");
    }

    public static class TraceDebugBorder
    extends CompoundBorder {
        private static final long serialVersionUID = -1396250213346461982L;

        public TraceDebugBorder(Border insideBorder) {
            super(BorderFactory.createLineBorder(Color.RED, 1), insideBorder);
        }

        public Insets getBorderInsets(Component c) {
            return this.getInsideBorder().getBorderInsets(c);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return this.getInsideBorder().getBorderInsets(c);
        }
    }

    public static interface GetHandler {
        public boolean condition(Component var1);

        public Component action(Component var1);
    }

    public static interface ConditionHandler
    extends Handler {
        public boolean stopCondition(Component var1);
    }

    public static interface Handler {
        public boolean condition(Component var1);

        public void action(Component var1);

        public void postAction(Component var1);
    }

    private static class GetPropertyAction
    implements PrivilegedAction {
        private String theProp;
        private String defaultVal;

        public GetPropertyAction(String theProp) {
            this.theProp = theProp;
        }

        public GetPropertyAction(String theProp, String defaultVal) {
            this.theProp = theProp;
            this.defaultVal = defaultVal;
        }

        public Object run() {
            String value = System.getProperty(this.theProp);
            return value == null ? this.defaultVal : value;
        }
    }
}

