/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;

public class JideSplitPaneLayout
extends JideBoxLayout {
    private static final long serialVersionUID = -1826651835409198865L;

    public JideSplitPaneLayout(Container target) {
        super(target);
        this.setResetWhenInvalidate(false);
    }

    public JideSplitPaneLayout(Container target, int axis) {
        super(target, axis);
        this.setResetWhenInvalidate(false);
    }

    public JideSplitPaneLayout(Container target, int axis, int gap) {
        super(target, axis, gap);
        this.setResetWhenInvalidate(false);
    }

    int getDividerLocation(int index) {
        Insets insets;
        int i;
        if (this._componentSizes == null) {
            return -1;
        }
        if (index < 0 || index + 1 << 1 >= this._componentSizes.length) {
            return -1;
        }
        boolean ltr = this._target.getComponentOrientation().isLeftToRight();
        boolean reversed = !ltr && ((JideSplitPane)this._target).getOrientation() == 1;
        int location = 0;
        if (reversed) {
            for (i = this._componentSizes.length - 1; i >= index * 2 + 1; --i) {
                location += this._componentSizes[i];
            }
        } else {
            for (i = 0; i < index * 2 + 1; ++i) {
                location += this._componentSizes[i];
            }
        }
        if ((insets = this._target.getInsets()) != null) {
            location = ((JideSplitPane)this._target).getOrientation() == 1 ? (location += reversed ? insets.right : insets.left) : (location += insets.top);
        }
        return location;
    }

    int setDividerLocation(int index, int location, boolean isOriginator) {
        int changedIndex;
        int actualLocation;
        int size;
        int flexiblePrevIndex;
        int flexibleNextIndex;
        int oldLocation = this.getDividerLocation(index);
        if (oldLocation == -1 || oldLocation == location) {
            return -1;
        }
        boolean ltr = this._target.getComponentOrientation().isLeftToRight();
        boolean reversed = !ltr && ((JideSplitPane)this._target).getOrientation() == 1;
        int prevIndex = reversed ? 2 * index + 2 : 2 * index;
        int nextIndex = reversed ? 2 * index : 2 * index + 2;
        int nextDividerIndex = reversed ? index - 1 : index + 1;
        int prevDividerIndex = reversed ? index + 1 : index - 1;
        ArrayList<Integer> componentIndexChanged = new ArrayList<Integer>();
        if (reversed) {
            while (nextIndex >= 0 && !this.isPaneVisible(nextIndex)) {
                nextIndex -= 2;
                --nextDividerIndex;
            }
            while (prevIndex < this._componentSizes.length && !this.isPaneVisible(prevIndex)) {
                prevIndex += 2;
                ++prevDividerIndex;
            }
            for (flexibleNextIndex = nextIndex; !(flexibleNextIndex < 0 || this.getConstraintMap().get(this._target.getComponent(flexibleNextIndex)) != "fix" && this.isPaneVisible(flexibleNextIndex)); flexibleNextIndex -= 2) {
            }
            if (flexibleNextIndex < 0) {
                return -1;
            }
            for (flexiblePrevIndex = prevIndex; !(flexiblePrevIndex >= this._componentSizes.length || this.getConstraintMap().get(this._target.getComponent(flexiblePrevIndex)) != "fix" && this.isPaneVisible(flexiblePrevIndex)); flexiblePrevIndex += 2) {
            }
            if (flexiblePrevIndex >= this._componentSizes.length) {
                return -1;
            }
        } else {
            while (nextIndex < this._componentSizes.length && !this.isPaneVisible(nextIndex)) {
                nextIndex += 2;
                ++nextDividerIndex;
            }
            while (prevIndex >= 0 && !this.isPaneVisible(prevIndex)) {
                prevIndex -= 2;
                --prevDividerIndex;
            }
            for (flexibleNextIndex = nextIndex; !(flexibleNextIndex >= this._componentSizes.length || this.getConstraintMap().get(this._target.getComponent(flexibleNextIndex)) != "fix" && this.isPaneVisible(flexibleNextIndex)); flexibleNextIndex += 2) {
            }
            if (flexibleNextIndex >= this._componentSizes.length) {
                return -1;
            }
            for (flexiblePrevIndex = prevIndex; !(flexiblePrevIndex < 0 || this.getConstraintMap().get(this._target.getComponent(flexiblePrevIndex)) != "fix" && this.isPaneVisible(flexiblePrevIndex)); flexiblePrevIndex -= 2) {
            }
            if (flexiblePrevIndex < 0) {
                return -1;
            }
        }
        if (isOriginator && this.getConstraintMap().get(this._target.getComponent(nextIndex)) == "fix" && this.getConstraintMap().get(this._target.getComponent(prevIndex)) == "fix") {
            return -1;
        }
        if (location > oldLocation) {
            size = this._componentSizes[2 * index + 1];
            size = this.getConstraintMap().get(this._target.getComponent(nextIndex)) == "fix" ? (size += this._componentSizes[nextIndex]) : (((JideSplitPane)this._target).getOrientation() == 1 ? (int)((double)size + this._target.getComponent(nextIndex).getMinimumSize().getWidth()) : (int)((double)size + this._target.getComponent(nextIndex).getMinimumSize().getHeight()));
            int nextDividerLocation = this.getDividerLocation(nextDividerIndex);
            if (nextDividerLocation < 0) {
                location = ((JideSplitPane)this._target).getOrientation() == 1 ? Math.min(location, this._target.getWidth() - size) : Math.min(location, this._target.getHeight() - size);
            } else if (location + size > nextDividerLocation) {
                actualLocation = this.setDividerLocation(nextDividerIndex, location + size, false);
                if (actualLocation == -1) {
                    return -1;
                }
                location = actualLocation - size;
            }
            if (this.getConstraintMap().get(this._target.getComponent(nextIndex)) != "fix") {
                int n = nextIndex;
                this._componentSizes[n] = this._componentSizes[n] - (location - oldLocation);
                componentIndexChanged.add(nextIndex);
            }
            if (isOriginator) {
                int n = flexiblePrevIndex;
                this._componentSizes[n] = this._componentSizes[n] + (location - oldLocation);
                componentIndexChanged.add(flexiblePrevIndex);
            } else if (this.getConstraintMap().get(this._target.getComponent(prevIndex)) != "fix") {
                int n = prevIndex;
                this._componentSizes[n] = this._componentSizes[n] + (location - oldLocation);
                componentIndexChanged.add(prevIndex);
            }
        } else if (location < oldLocation) {
            size = 0;
            if (prevDividerIndex >= 0) {
                size = this._componentSizes[prevIndex - 1];
            }
            size = this.getConstraintMap().get(this._target.getComponent(prevIndex)) == "fix" ? (size += this._componentSizes[prevIndex]) : (((JideSplitPane)this._target).getOrientation() == 1 ? (int)((double)size + this._target.getComponent(prevIndex).getMinimumSize().getWidth()) : (int)((double)size + this._target.getComponent(prevIndex).getMinimumSize().getHeight()));
            int prevDividerLocation = this.getDividerLocation(prevDividerIndex);
            if (prevDividerLocation < 0) {
                location = Math.max(location, size);
            } else if (location - size < prevDividerLocation) {
                actualLocation = this.setDividerLocation(prevDividerIndex, location - size, false);
                if (actualLocation == -1) {
                    return -1;
                }
                location = actualLocation + size;
            }
            if (this.getConstraintMap().get(this._target.getComponent(prevIndex)) != "fix") {
                int n = prevIndex;
                this._componentSizes[n] = this._componentSizes[n] - (oldLocation - location);
                componentIndexChanged.add(prevIndex);
            }
            if (isOriginator) {
                int n = flexibleNextIndex;
                this._componentSizes[n] = this._componentSizes[n] + (oldLocation - location);
                componentIndexChanged.add(flexibleNextIndex);
            } else if (this.getConstraintMap().get(this._target.getComponent(nextIndex)) != "fix") {
                int n = nextIndex;
                this._componentSizes[n] = this._componentSizes[n] + (oldLocation - location);
                componentIndexChanged.add(nextIndex);
            }
        }
        this._target.firePropertyChange("dividerLocation", (long)oldLocation, (long)location);
        ((JideSplitPane)this._target).revalidate();
        if (((JideSplitPane)this._target).isProportionalLayout()) {
            this.replaceProportions();
            return location;
        }
        if (((JideSplitPane)this._target).getOrientation() == 1) {
            Iterator i$ = componentIndexChanged.iterator();
            while (i$.hasNext()) {
                changedIndex = (Integer)i$.next();
                Component component = this._target.getComponent(changedIndex);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).setPreferredSize(new Dimension(this._componentSizes[changedIndex], component.getPreferredSize().height));
            }
        } else {
            Iterator i$ = componentIndexChanged.iterator();
            while (i$.hasNext()) {
                changedIndex = (Integer)i$.next();
                Component component = this._target.getComponent(changedIndex);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).setPreferredSize(new Dimension(component.getPreferredSize().width, this._componentSizes[changedIndex]));
            }
        }
        return location;
    }

    private boolean isPaneVisible(int index) {
        return index < this._componentSizes.length && (this._componentSizes[index] != 0 || index - 1 < 0 || this._componentSizes[index - 1] != 0);
    }

    private void replaceProportions() {
        ((JideSplitPane)this._target).setProportions(this.deduceProportions());
    }

    private double[] deduceProportions() {
        double[] newProportions;
        double total = 0.0;
        for (int i = 0; i < this._componentSizes.length; i += 2) {
            total += (double)this._componentSizes[i];
        }
        if (total == 0.0) {
            newProportions = null;
        } else {
            newProportions = new double[(this._componentSizes.length - 1) / 2];
            for (int i = 0; i < newProportions.length; ++i) {
                newProportions[i] = (double)this._componentSizes[i * 2] / total;
            }
        }
        return newProportions;
    }

    protected boolean calculateComponentSizes(int availableSize, int startIndex, int endIndex) {
        int i;
        if (!((JideSplitPane)this._target).isProportionalLayout() || this._target.getComponentCount() <= 1) {
            return super.calculateComponentSizes(availableSize, startIndex, endIndex);
        }
        if (((JideSplitPane)this._target).getProportions() == null) {
            if (!((JideSplitPane)this._target).isInitiallyEven()) {
                return super.calculateComponentSizes(availableSize, startIndex, endIndex);
            }
            int c = ((JideSplitPane)this._target).getPaneCount();
            double[] p = new double[c - 1];
            for (i = 0; i < p.length; ++i) {
                p[i] = 1.0 / (double)c;
            }
            ((JideSplitPane)this._target).internalSetProportions(p);
        }
        for (int i2 = 1; i2 < this._target.getComponentCount(); i2 += 2) {
            if (this._target.getComponent(i2).isVisible()) {
                this._componentSizes[i2] = ((JideSplitPane)this._target).getDividerSize();
            }
            availableSize -= this._componentSizes[i2];
        }
        if (availableSize < 0) {
            return false;
        }
        double[] proportions = ((JideSplitPane)this._target).getProportions();
        int size = availableSize;
        for (i = 0; i < proportions.length; ++i) {
            double d;
            int j = i * 2;
            if (this._target.getComponent(j).isVisible() && (d = proportions[i]) <= 1.0) {
                this._componentSizes[j] = (int)(0.5 + (double)size * d);
            }
            availableSize -= this._componentSizes[j];
        }
        if (availableSize < 0) {
            return false;
        }
        this._componentSizes[this._componentSizes.length - 1] = availableSize;
        return true;
    }
}

