/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPaneConstants;
import com.jidesoft.swing.JideScrollPaneLayout;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.plaf.UIResource;

public class JideScrollPane
extends JScrollPane
implements JideScrollPaneConstants {
    protected JViewport _rowFooter;
    protected JViewport _columnFooter;
    protected Component _hLeft;
    protected Component _hRight;
    protected Component _vTop;
    protected Component _vBottom;
    private boolean _keepCornerVisible = false;
    private boolean _horizontalScrollBarCoversWholeWidth;
    private boolean _verticalScrollBarCoversWholeHeight;
    public static final String PROPERTY_HORIZONTAL_SCROLL_BAR_COVERS_WHOLE_WIDTH = "horizontalScrollBarCoversWholeWidth";
    public static final String PROPERTY_VERTICAL_SCROLL_BAR_COVERS_WHOLE_HEIGHT = "verticalScrollBarCoversWholeHeight";
    private boolean _columnHeadersHeightUnified;
    private boolean _columnFootersHeightUnified;
    public static final String PROPERTY_COLUMN_HEADERS_HEIGHT_UNIFIED = "columnHeadersHeightUnified";
    public static final String PROPERTY_COLUMN_FOOTERS_HEIGHT_UNIFIED = "columnFootersHeightUnified";

    public JideScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        this.setLayout(new JideScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(vsbPolicy);
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setViewport(this.createViewport());
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        if (null != view) {
            this.setViewportView(view);
        }
        this.setOpaque(true);
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
    }

    public JideScrollPane(Component view) {
        this(view, 20, 30);
    }

    public JideScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public JideScrollPane() {
        this(null, 20, 30);
    }

    public JViewport getRowFooter() {
        return this._rowFooter;
    }

    public void setRowFooter(JViewport rowFooter) {
        JViewport old = this.getRowFooter();
        this._rowFooter = rowFooter;
        if (null != rowFooter) {
            this.add((Component)rowFooter, "ROW_FOOTER");
        } else if (null != old) {
            this.remove(old);
        }
        this.firePropertyChange("rowFooter", old, rowFooter);
        this.revalidate();
        this.repaint();
        JideSwingUtilities.synchronizeView(rowFooter, this.getViewport(), 1);
        JideSwingUtilities.synchronizeView(this.getViewport(), rowFooter, 1);
    }

    public void setRowHeader(JViewport rowHeader) {
        super.setRowHeader(rowHeader);
        JideSwingUtilities.synchronizeView(rowHeader, this.getViewport(), 1);
    }

    public void setRowFooterView(Component view) {
        if (null == this.getRowFooter()) {
            this.setRowFooter(this.createViewport());
        }
        this.getRowFooter().setView(view);
    }

    public JViewport getColumnFooter() {
        return this._columnFooter;
    }

    public void setColumnFooter(JViewport columnFooter) {
        JViewport old = this.getColumnFooter();
        this._columnFooter = columnFooter;
        if (null != columnFooter) {
            this.add((Component)columnFooter, "COLUMN_FOOTER");
        } else if (null != old) {
            this.remove(old);
        }
        this.firePropertyChange("columnFooter", old, columnFooter);
        this.revalidate();
        this.repaint();
        JideSwingUtilities.synchronizeView(this._columnFooter, this.getViewport(), 0);
        JideSwingUtilities.synchronizeView(this.getViewport(), this._columnFooter, 0);
    }

    public void setColumnHeader(JViewport columnHeader) {
        super.setColumnHeader(columnHeader);
        JideSwingUtilities.synchronizeView(this.columnHeader, this.getViewport(), 0);
    }

    public void setColumnFooterView(Component view) {
        if (null == this.getColumnFooter()) {
            this.setColumnFooter(this.createViewport());
        }
        this.getColumnFooter().setView(view);
    }

    public Component getScrollBarCorner(String key) {
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        if (key.equals("HORIZONTAL_LEADING")) {
            key = isLeftToRight ? "HORIZONTAL_LEFT" : "HORIZONTAL_RIGHT";
        } else if (key.equals("HORIZONTAL_TRAILING")) {
            String string = key = isLeftToRight ? "HORIZONTAL_RIGHT" : "HORIZONTAL_LEFT";
        }
        if (key.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (key.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (key.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (key.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        return null;
    }

    public void setScrollBarCorner(String key, Component corner) {
        Component old;
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        if (key.equals("HORIZONTAL_LEADING")) {
            key = isLeftToRight ? "HORIZONTAL_LEFT" : "HORIZONTAL_RIGHT";
        } else if (key.equals("HORIZONTAL_TRAILING")) {
            String string = key = isLeftToRight ? "HORIZONTAL_RIGHT" : "HORIZONTAL_LEFT";
        }
        if (key.equals("HORIZONTAL_LEFT")) {
            old = this._hLeft;
            this._hLeft = corner;
        } else if (key.equals("HORIZONTAL_RIGHT")) {
            old = this._hRight;
            this._hRight = corner;
        } else if (key.equals("VERTICAL_TOP")) {
            old = this._vTop;
            this._vTop = corner;
        } else if (key.equals("VERTICAL_BOTTOM")) {
            old = this._vBottom;
            this._vBottom = corner;
        } else {
            throw new IllegalArgumentException("invalid scroll bar corner key");
        }
        if (null != old) {
            this.remove(old);
        }
        if (null != corner) {
            this.add(corner, key);
        }
        if (corner != null) {
            corner.setComponentOrientation(this.getComponentOrientation());
        }
        this.firePropertyChange(key, old, corner);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        super.updateUI();
        this.setLayout(new JideScrollPaneLayout.UIResource());
        if (this.getBorder() instanceof UIResource) {
            LookAndFeel.installBorder(this, "JideScrollPane.border");
        }
    }

    public boolean isVerticalScrollBarCoversWholeHeight() {
        return this._verticalScrollBarCoversWholeHeight;
    }

    public void setHorizontalScrollBarCoversWholeWidth(boolean horizontalScrollBarCoversWholeWidth) {
        boolean old = this._horizontalScrollBarCoversWholeWidth;
        if (old != horizontalScrollBarCoversWholeWidth) {
            this._horizontalScrollBarCoversWholeWidth = horizontalScrollBarCoversWholeWidth;
            this.firePropertyChange(PROPERTY_HORIZONTAL_SCROLL_BAR_COVERS_WHOLE_WIDTH, old, this._horizontalScrollBarCoversWholeWidth);
            this.invalidate();
            this.doLayout();
            if (this.getHorizontalScrollBar() != null) {
                this.getHorizontalScrollBar().doLayout();
            }
        }
    }

    public boolean isHorizontalScrollBarCoversWholeWidth() {
        return this._horizontalScrollBarCoversWholeWidth;
    }

    public void setVerticalScrollBarCoversWholeHeight(boolean verticalScrollBarCoversWholeHeight) {
        boolean old = this._verticalScrollBarCoversWholeHeight;
        if (old != verticalScrollBarCoversWholeHeight) {
            this._verticalScrollBarCoversWholeHeight = verticalScrollBarCoversWholeHeight;
            this.firePropertyChange(PROPERTY_VERTICAL_SCROLL_BAR_COVERS_WHOLE_HEIGHT, old, this._verticalScrollBarCoversWholeHeight);
            this.invalidate();
            this.doLayout();
            if (this.getVerticalScrollBar() != null) {
                this.getVerticalScrollBar().doLayout();
            }
        }
    }

    public boolean isColumnHeadersHeightUnified() {
        return this._columnHeadersHeightUnified;
    }

    public void setColumnHeadersHeightUnified(boolean columnHeadersHeightUnified) {
        boolean old = this._columnHeadersHeightUnified;
        if (old != columnHeadersHeightUnified) {
            this._columnHeadersHeightUnified = columnHeadersHeightUnified;
            this.firePropertyChange(PROPERTY_COLUMN_HEADERS_HEIGHT_UNIFIED, old, this._horizontalScrollBarCoversWholeWidth);
            this.invalidate();
            this.doLayout();
        }
    }

    public boolean isColumnFootersHeightUnified() {
        return this._columnFootersHeightUnified;
    }

    public void setColumnFootersHeightUnified(boolean columnFootersHeightUnified) {
        boolean old = this._columnFootersHeightUnified;
        if (old != columnFootersHeightUnified) {
            this._columnFootersHeightUnified = columnFootersHeightUnified;
            this.firePropertyChange(PROPERTY_COLUMN_FOOTERS_HEIGHT_UNIFIED, old, this._horizontalScrollBarCoversWholeWidth);
            this.invalidate();
            this.doLayout();
        }
    }

    public boolean isKeepCornerVisible() {
        return this._keepCornerVisible;
    }

    public void setKeepCornerVisible(boolean keepCornerVisible) {
        this._keepCornerVisible = keepCornerVisible;
    }
}

