/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer _treeCellRenderer;
    private CheckBoxTreeSelectionModel _checkBoxTreeSelectionModel;
    private boolean _checkBoxEnabled = true;
    private PropertyChangeListener _modelChangeListener;
    private TreeCellRenderer _defaultRenderer;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(Vector<?> value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(Hashtable<?, ?> value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(TreeNode root) {
        super(root);
        this.init();
    }

    public CheckBoxTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public CheckBoxTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    protected void init() {
        this._checkBoxTreeSelectionModel = this.createCheckBoxTreeSelectionModel(this.getModel());
        this._checkBoxTreeSelectionModel.setTree(this);
        Handler handler = this.createHandler();
        JideSwingUtilities.insertMouseListener(this, handler, 0);
        this.addKeyListener(handler);
        this._checkBoxTreeSelectionModel.addTreeSelectionListener(handler);
        if (this._modelChangeListener == null) {
            this._modelChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectionModel".equals(evt.getPropertyName())) {
                        CheckBoxTree.this.updateRowMapper();
                    }
                    if ("model".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TreeModel) {
                        CheckBoxTree.this._checkBoxTreeSelectionModel.setModel((TreeModel)evt.getNewValue());
                    }
                }
            };
        }
        this.addPropertyChangeListener("selectionModel", this._modelChangeListener);
        this.addPropertyChangeListener("model", this._modelChangeListener);
        this.updateRowMapper();
    }

    protected CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel model) {
        return new CheckBoxTreeSelectionModel(model);
    }

    private void updateRowMapper() {
        this._checkBoxTreeSelectionModel.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer cellRenderer = this.getActualCellRenderer();
        if (cellRenderer == null) {
            cellRenderer = this.getDefaultRenderer();
        }
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = this.createCellRenderer(cellRenderer);
        } else {
            this._treeCellRenderer.setActualTreeRenderer(cellRenderer);
        }
        return this._treeCellRenderer;
    }

    private TreeCellRenderer getDefaultRenderer() {
        if (this._defaultRenderer == null) {
            this._defaultRenderer = new DefaultTreeCellRenderer();
        }
        return this._defaultRenderer;
    }

    public TreeCellRenderer getActualCellRenderer() {
        if (this._treeCellRenderer != null) {
            return this._treeCellRenderer.getActualTreeRenderer();
        }
        return super.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer x) {
        if (x == null) {
            x = this.getDefaultRenderer();
        }
        super.setCellRenderer(x);
        if (this._treeCellRenderer != null) {
            this._treeCellRenderer.setActualTreeRenderer(x);
        }
    }

    protected CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer renderer) {
        final CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(renderer);
        this.addPropertyChangeListener("cellRenderer", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TreeCellRenderer treeCellRenderer = (TreeCellRenderer)evt.getNewValue();
                if (treeCellRenderer != checkBoxTreeCellRenderer) {
                    checkBoxTreeCellRenderer.setActualTreeRenderer(treeCellRenderer);
                } else {
                    checkBoxTreeCellRenderer.setActualTreeRenderer(null);
                }
            }
        });
        return checkBoxTreeCellRenderer;
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    public CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this._checkBoxTreeSelectionModel;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this._checkBoxEnabled) {
            Boolean oldValue = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, oldValue, newValue);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath path) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath path) {
        return true;
    }

    public boolean isDigIn() {
        return this.getCheckBoxTreeSelectionModel().isDigIn();
    }

    public void setDigIn(boolean digIn) {
        boolean old = this.isDigIn();
        if (old != digIn) {
            this.getCheckBoxTreeSelectionModel().setDigIn(digIn);
            this.firePropertyChange(PROPERTY_DIG_IN, old, digIn);
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    TreeSelectionListener {
        protected CheckBoxTree _tree;
        int _hotspot;
        private int _toggleCount;

        public Handler(CheckBoxTree tree) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._toggleCount = -1;
            this._tree = tree;
        }

        protected TreePath getTreePathForMouseEvent(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return null;
            }
            TreePath path = this._tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            if (this.clicksInCheckBox(e, path)) {
                return path;
            }
            return null;
        }

        protected boolean clicksInCheckBox(MouseEvent e, TreePath path) {
            if (!this._tree.isCheckBoxVisible(path)) {
                return false;
            }
            Rectangle bounds = this._tree.getPathBounds(path);
            if (this._tree.getComponentOrientation().isLeftToRight()) {
                return e.getX() < bounds.x + this._hotspot;
            }
            return e.getX() > bounds.x + bounds.width - this._hotspot;
        }

        private TreePath preventToggleEvent(MouseEvent e) {
            int toggleCount;
            TreePath pathForMouseEvent = this.getTreePathForMouseEvent(e);
            if (pathForMouseEvent != null && (toggleCount = this._tree.getToggleClickCount()) != -1) {
                this._toggleCount = toggleCount;
                this._tree.setToggleClickCount(-1);
            }
            return pathForMouseEvent;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.preventToggleEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            TreePath path = this.preventToggleEvent(e);
            if (path != null) {
                this.toggleSelection(path);
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            TreePath path = this.preventToggleEvent(e);
            if (path != null) {
                e.consume();
            }
            if (this._toggleCount != -1) {
                this._tree.setToggleClickCount(this._toggleCount);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void valueChanged(TreeSelectionEvent e) {
            this._tree.treeDidChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleSelection(TreePath path) {
            if (!this._tree.isEnabled() || !this._tree.isCheckBoxEnabled(path)) {
                return;
            }
            CheckBoxTreeSelectionModel selectionModel = this._tree.getCheckBoxTreeSelectionModel();
            boolean selected = selectionModel.isPathSelected(path, selectionModel.isDigIn());
            selectionModel.removeTreeSelectionListener(this);
            try {
                if (!selectionModel.isSingleEventMode()) {
                    selectionModel.setBatchMode(true);
                }
                if (selected) {
                    selectionModel.removeSelectionPath(path);
                } else {
                    selectionModel.addSelectionPath(path);
                }
            }
            finally {
                if (!selectionModel.isSingleEventMode()) {
                    selectionModel.setBatchMode(false);
                }
                selectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }

        protected void toggleSelections() {
            TreePath[] treePaths = this._tree.getSelectionPaths();
            if (treePaths == null) {
                return;
            }
            for (TreePath treePath : treePaths) {
                this.toggleSelection(treePath);
            }
        }
    }
}

