/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.ComboBoxSearchable;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.Searchable;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.tree.TreePath;

public class AutoCompletion {
    private Searchable _searchable;
    private JTextComponent _textComponent;
    private AutoCompletionDocument _document;
    private boolean _selecting = false;
    private boolean _hidePopupOnFocusLoss;
    private boolean _keyTyped = false;
    private boolean _hitBackspace = false;
    private boolean _hitBackspaceOnSelection;
    private KeyListener _editorKeyListener;
    private boolean _strict = true;
    private boolean _strictCompletion = true;
    private PropertyChangeListener _propertyChangeListener;
    private JComboBox _comboBox;
    private Document _oldDocument;
    public static final String CLIENT_PROPERTY_AUTO_COMPLETION = "AutoCompletion";

    public AutoCompletion(JComboBox comboBox) {
        this(comboBox, (Searchable)new ComboBoxSearchable(comboBox));
    }

    public AutoCompletion(JComboBox comboBox, Searchable searchable) {
        this._searchable = searchable;
        this._propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if ("editor".equals(e.getPropertyName()) && e.getNewValue() != null) {
                    AutoCompletion.this._textComponent = (JTextComponent)((ComboBoxEditor)e.getNewValue()).getEditorComponent();
                    AutoCompletion.this.configureEditor(AutoCompletion.this.getTextComponent());
                }
            }
        };
        this._comboBox = comboBox;
        this._searchable.setWildcardEnabled(false);
        if (this._searchable instanceof ComboBoxSearchable) {
            ((ComboBoxSearchable)this._searchable).setShowPopupDuringSearching(false);
        }
        this._textComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
        this.installListeners();
    }

    public AutoCompletion(JTextComponent textComponent, Searchable searchable) {
        this._searchable = searchable;
        this._searchable.setWildcardEnabled(false);
        this._textComponent = textComponent;
        this.registerSelectionListener(this.getSearchable());
        this.installListeners();
    }

    public AutoCompletion(JTextComponent textComponent, final List list) {
        this(textComponent, new Searchable((JComponent)new JLabel()){
            int _selectIndex;
            {
                super(x0);
                this._selectIndex = -1;
            }

            protected int getSelectedIndex() {
                return this._selectIndex;
            }

            protected void setSelectedIndex(int index, boolean incremental) {
                this._selectIndex = index;
            }

            protected int getElementCount() {
                return list.size();
            }

            protected Object getElementAt(int index) {
                return list.get(index);
            }

            protected String convertElementToString(Object element) {
                return "" + element;
            }
        });
    }

    public AutoCompletion(JTextComponent textComponent, final Object[] array) {
        this(textComponent, new Searchable((JComponent)new JLabel()){
            int _selectIndex;
            {
                super(x0);
                this._selectIndex = -1;
            }

            protected int getSelectedIndex() {
                return this._selectIndex;
            }

            protected void setSelectedIndex(int index, boolean incremental) {
                this._selectIndex = index;
            }

            protected int getElementCount() {
                return array.length;
            }

            protected Object getElementAt(int index) {
                return array[index];
            }

            protected String convertElementToString(Object element) {
                return "" + element;
            }
        });
    }

    private void registerSelectionListener(Searchable searchable) {
        if (searchable.getComponent() instanceof JList) {
            final JList list = (JList)this.getSearchable().getComponent();
            list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int index = list.getSelectedIndex();
                    if (index != -1) {
                        AutoCompletion.this.getTextComponent().setText("" + list.getModel().getElementAt(index));
                        AutoCompletion.this.highlightCompletedText(0);
                    }
                }
            });
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, list, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, list, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, list, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, list, 0, KeyStroke.getKeyStroke(34, 0));
        } else if (searchable.getComponent() instanceof JTree) {
            final JTree tree = (JTree)this.getSearchable().getComponent();
            tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreePath treePath = tree.getSelectionPath();
                    if (treePath != null) {
                        AutoCompletion.this.getTextComponent().setText("" + treePath.getLastPathComponent());
                        AutoCompletion.this.highlightCompletedText(0);
                    }
                }
            });
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, tree, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, tree, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, tree, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, tree, 0, KeyStroke.getKeyStroke(34, 0));
        }
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean keyTyped) {
        this._keyTyped = keyTyped;
    }

    private void setInitValue() {
        int index = this.getSearchable().getSelectedIndex();
        if (index != -1) {
            Object selected = this.getSearchable().getElementAt(index);
            if (selected != null) {
                this._document.setText(this.getSearchable().convertElementToString(selected));
            }
            this.highlightCompletedText(0);
        } else {
            this._document.setText("");
        }
    }

    public void uninstallListeners() {
        if (this._propertyChangeListener != null && this._comboBox != null) {
            this._comboBox.removePropertyChangeListener(this._propertyChangeListener);
        }
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this._editorKeyListener);
            String text = this.getTextComponent().getText();
            if (this._oldDocument != null) {
                this.getTextComponent().setDocument(this._oldDocument);
                this._oldDocument = null;
            }
            this.getTextComponent().setText(text);
        }
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, null);
    }

    public void installListeners() {
        if (this._comboBox != null && this._propertyChangeListener != null) {
            this._comboBox.addPropertyChangeListener(this._propertyChangeListener);
        }
        this._editorKeyListener = new KeyAdapter(){
            private boolean _deletePressed;
            private String _saveText;

            public void keyPressed(KeyEvent e) {
                AutoCompletion.this._hitBackspace = false;
                if (27 != e.getKeyCode()) {
                    AutoCompletion.this.setKeyTyped(true);
                }
                switch (e.getKeyCode()) {
                    case 8: {
                        if (!AutoCompletion.this.isStrict()) break;
                        AutoCompletion.this._hitBackspace = true;
                        AutoCompletion.this._hitBackspaceOnSelection = AutoCompletion.this.getTextComponent().getSelectionStart() != AutoCompletion.this.getTextComponent().getSelectionEnd();
                        break;
                    }
                    case 127: {
                        if (!AutoCompletion.this.isStrict()) break;
                        this._deletePressed = true;
                        this._saveText = AutoCompletion.this.getTextComponent().getText();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                try {
                    if (this._deletePressed) {
                        this._deletePressed = false;
                        String text = AutoCompletion.this.getTextComponent().getText();
                        int index = AutoCompletion.this.getSearchable().findFirst(text);
                        if (index != -1) {
                            if (text.length() == 0) {
                                AutoCompletion.this.setSelectedItem(null);
                            } else {
                                Object item = AutoCompletion.this.getSearchable().getElementAt(index);
                                AutoCompletion.this.setSelectedItem(item);
                                AutoCompletion.this.getTextComponent().setText(AutoCompletion.this.getSearchable().convertElementToString(item));
                                AutoCompletion.this.highlightCompletedText(text.length());
                            }
                        } else if (AutoCompletion.this.isStrict()) {
                            AutoCompletion.this.getTextComponent().setText(this._saveText);
                            e.consume();
                            PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                        }
                    }
                }
                finally {
                    if (27 != e.getKeyCode()) {
                        AutoCompletion.this.setKeyTyped(false);
                    }
                }
            }
        };
        this._hidePopupOnFocusLoss = SystemInfo.isJdk15Above();
        this._document = this.createDocument();
        this.configureEditor(this.getTextComponent());
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, this);
    }

    protected AutoCompletionDocument createDocument() {
        return new AutoCompletionDocument();
    }

    private void configureEditor(JTextComponent textComponent) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this._editorKeyListener);
        }
        if (textComponent != null) {
            this._textComponent = textComponent;
            this.getTextComponent().addKeyListener(this._editorKeyListener);
            String text = this.getTextComponent().getText();
            this._oldDocument = this.getTextComponent().getDocument();
            this.getTextComponent().setDocument(this._document);
            this.getTextComponent().setText(text);
        }
    }

    private void highlightCompletedText(int start) {
        int length = this.getTextComponent().getDocument().getLength();
        this.getTextComponent().setCaretPosition(length);
        if (start < 0) {
            start = 0;
        }
        if (start > length) {
            start = length;
        }
        this.getTextComponent().moveCaretPosition(start);
    }

    private void setSelectedItem(Object item) {
        this._selecting = true;
        int n = this.getSearchable().getElementCount();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.getSearchable().getElementAt(i);
            if (item != currentItem) continue;
            this.getSearchable().setSelectedIndex(i, false);
        }
        this._selecting = false;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public boolean isStrictCompletion() {
        return this._strictCompletion;
    }

    public void setStrictCompletion(boolean strictCompletion) {
        this._strictCompletion = strictCompletion;
    }

    protected JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    public static AutoCompletion getAutoCompletion(JComponent component) {
        if (component == null) {
            return null;
        }
        Object clientProperty = component.getClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION);
        if (clientProperty instanceof AutoCompletion) {
            return (AutoCompletion)clientProperty;
        }
        return null;
    }

    protected class AutoCompletionDocument
    extends PlainDocument {
        protected AutoCompletionDocument() {
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (AutoCompletion.this._selecting) {
                return;
            }
            if (AutoCompletion.this._hitBackspace) {
                if (offs > 0) {
                    if (AutoCompletion.this._hitBackspaceOnSelection) {
                        --offs;
                    }
                } else {
                    PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                }
                AutoCompletion.this.highlightCompletedText(offs);
            } else {
                super.remove(offs, len);
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (AutoCompletion.this._selecting) {
                return;
            }
            super.insertString(offs, str, a);
            if (AutoCompletion.this.isKeyTyped() || AutoCompletion.this.isStrict()) {
                String text = this.getText(0, this.getLength());
                int index = AutoCompletion.this.getSearchable().findFromCursor(text);
                if (index != -1) {
                    Object item = AutoCompletion.this.getSearchable().getElementAt(index);
                    AutoCompletion.this.setSelectedItem(item);
                    this.setText(AutoCompletion.this.getSearchable().convertElementToString(item));
                    AutoCompletion.this.highlightCompletedText(offs + str.length());
                } else if (AutoCompletion.this.isStrict()) {
                    index = AutoCompletion.this.getSearchable().getSelectedIndex();
                    if (index == -1 && AutoCompletion.this.getSearchable().getElementCount() > 0) {
                        index = 0;
                        AutoCompletion.this.getSearchable().setSelectedIndex(0, false);
                    }
                    if (index != -1) {
                        Object item = AutoCompletion.this.getSearchable().getElementAt(index);
                        PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                        this.setText(AutoCompletion.this.getSearchable().convertElementToString(item));
                        AutoCompletion.this.highlightCompletedText((offs -= str.length()) + str.length());
                    }
                }
            }
        }

        protected void setText(String text) {
            try {
                if (AutoCompletion.this.isStrictCompletion()) {
                    super.remove(0, this.getLength());
                    super.insertString(0, text, null);
                } else {
                    String existingText = super.getText(0, this.getLength());
                    int matchIndex = existingText.length() <= text.length() ? existingText.length() : text.length();
                    for (int i = 0; i < existingText.length(); ++i) {
                        if (existingText.substring(0, matchIndex).equalsIgnoreCase(text.substring(0, matchIndex))) continue;
                        --matchIndex;
                    }
                    super.remove(matchIndex, this.getLength() - matchIndex);
                    super.insertString(matchIndex, text.substring(matchIndex), null);
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

