/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFolderChooserIconsFactory;
import com.jidesoft.plaf.basic.FolderChooserResource;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderToolBar
extends JToolBar {
    private static final FileSystemView _fsv = FileSystemView.getFileSystemView();
    private JButton _deleteFolderBtn;
    private JButton _newFolderBtn;
    private JComboBox _recentFoldersList;
    private List<FolderToolBarListener> _listeners = new ArrayList<FolderToolBarListener>(1);
    private static final String DELETE_BUTTON_NAME = "FolderChooser.toolbar.delete";
    private static final String NEW_BUTTON_NAME = "FolderChooser.toolbar.new";
    private static final String REFRESH_BUTTON_NAME = "FolderChooser.toolbar.refresh";
    private static final String DESKTOP_BUTTON_NAME = "FolderChooser.toolbar.desktop";
    private static final String MY_DOCUMENTS_BUTTON_NAME = "FolderChooser.toolbar.mydocuments";

    public FolderToolBar(boolean showRecentFolders, List<String> recentFoldersList) {
        this.setFloatable(false);
        this.setupToolBar(showRecentFolders, recentFoldersList);
    }

    public void enableDelete() {
        this._deleteFolderBtn.setEnabled(true);
    }

    public void disableDelete() {
        this._deleteFolderBtn.setEnabled(false);
    }

    public void enableNewFolder() {
        this._newFolderBtn.setEnabled(true);
    }

    public void disableNewFolder() {
        this._newFolderBtn.setEnabled(false);
    }

    private void setupToolBar(boolean showRecentFolders, List<String> recentFoldersList) {
        if (showRecentFolders) {
            this._recentFoldersList = new JComboBox(new DefaultComboBoxModel());
            if (recentFoldersList != null && recentFoldersList.size() > 0) {
                this._recentFoldersList.setModel(new DefaultComboBoxModel<Object>(recentFoldersList.toArray()));
            }
            this._recentFoldersList.setEditable(false);
            this._recentFoldersList.setRenderer(new FileListCellRenderer());
            this._recentFoldersList.addPopupMenuListener(new PopupMenuListener(){
                private boolean m_wasCancelled = false;

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.m_wasCancelled = false;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (e.getSource() instanceof JComboBox) {
                        JComboBox box = (JComboBox)e.getSource();
                        Object selectedFile = box.getModel().getSelectedItem();
                        if (!this.m_wasCancelled && selectedFile != null) {
                            if (selectedFile instanceof File) {
                                FolderToolBar.this.recentFolderSelected((File)selectedFile);
                            } else {
                                FolderToolBar.this.recentFolderSelected(new File("" + selectedFile));
                            }
                        }
                    }
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                    this.m_wasCancelled = true;
                }
            });
            this._recentFoldersList.setPrototypeDisplayValue("AAAAAAAAAAAAAAAAAA");
            ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
            this.add(new JLabel(resourceBundle.getString("FolderChooser.toolbar.recent")));
            this.add(this._recentFoldersList);
        } else {
            this.add(Box.createHorizontalGlue());
        }
        NoFocusButton desktopBtn = new NoFocusButton(new ToolBarAction(null, SystemInfo.isWindows() ? _fsv.getSystemIcon(_fsv.getHomeDirectory()) : BasicFolderChooserIconsFactory.getImageIcon("icons/home.png")){

            public void actionPerformed(ActionEvent e) {
                FolderToolBar.this.desktopButtonClicked();
            }
        });
        ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
        desktopBtn.setToolTipText(SystemInfo.isWindows() ? resourceBundle.getString(DESKTOP_BUTTON_NAME) : resourceBundle.getString("FolderChooser.toolbar.home"));
        desktopBtn.setName(DESKTOP_BUTTON_NAME);
        this.add(desktopBtn);
        if (SystemInfo.isWindows()) {
            NoFocusButton myDocumentsBtn = new NoFocusButton(new ToolBarAction(null, _fsv.getSystemIcon(_fsv.getDefaultDirectory())){

                public void actionPerformed(ActionEvent e) {
                    FolderToolBar.this.myDocumentsButtonClicked();
                }
            });
            myDocumentsBtn.setToolTipText(resourceBundle.getString(MY_DOCUMENTS_BUTTON_NAME));
            myDocumentsBtn.setName(MY_DOCUMENTS_BUTTON_NAME);
            this.add(myDocumentsBtn);
        }
        ImageIcon deleteIcon = BasicFolderChooserIconsFactory.getImageIcon("icons/delete.png");
        this._deleteFolderBtn = new NoFocusButton(new ToolBarAction(null, deleteIcon){

            public void actionPerformed(ActionEvent e) {
                FolderToolBar.this.deleteFolderButtonClicked();
            }
        });
        this._deleteFolderBtn.setToolTipText(resourceBundle.getString(DELETE_BUTTON_NAME));
        this._deleteFolderBtn.setName(DELETE_BUTTON_NAME);
        ImageIcon newFolderIcon = BasicFolderChooserIconsFactory.getImageIcon("icons/new.png");
        this._newFolderBtn = new NoFocusButton(new ToolBarAction(null, newFolderIcon){

            public void actionPerformed(ActionEvent e) {
                FolderToolBar.this.newFolderButtonClicked();
            }
        });
        this._newFolderBtn.setToolTipText(resourceBundle.getString(NEW_BUTTON_NAME));
        this._newFolderBtn.setName(NEW_BUTTON_NAME);
        ImageIcon refreshIcon = BasicFolderChooserIconsFactory.getImageIcon("icons/refresh.png");
        NoFocusButton refreshBtn = new NoFocusButton(new ToolBarAction(null, refreshIcon){

            public void actionPerformed(ActionEvent e) {
                FolderToolBar.this.refreshButtonClicked();
            }
        });
        refreshBtn.setToolTipText(resourceBundle.getString(REFRESH_BUTTON_NAME));
        refreshBtn.setName(REFRESH_BUTTON_NAME);
        this.add(this._deleteFolderBtn);
        this.add(this._newFolderBtn);
        this.add(refreshBtn);
    }

    boolean isButtonVisible(String buttonName, int availableButtons) {
        if (DELETE_BUTTON_NAME.equals(buttonName)) {
            return (availableButtons & 1) != 0;
        }
        if (NEW_BUTTON_NAME.equals(buttonName)) {
            return (availableButtons & 2) != 0;
        }
        if (REFRESH_BUTTON_NAME.equals(buttonName)) {
            return (availableButtons & 4) != 0;
        }
        if (DESKTOP_BUTTON_NAME.equals(buttonName)) {
            return (availableButtons & 8) != 0;
        }
        if (MY_DOCUMENTS_BUTTON_NAME.equals(buttonName)) {
            return (availableButtons & 0x10) != 0;
        }
        return true;
    }

    public void addListener(FolderToolBarListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(FolderToolBarListener listener) {
        this._listeners.remove(listener);
    }

    public void clearListeners() {
        this._listeners.clear();
    }

    private void deleteFolderButtonClicked() {
        for (FolderToolBarListener listener : this._listeners) {
            listener.deleteFolderButtonClicked();
        }
    }

    private void newFolderButtonClicked() {
        for (FolderToolBarListener listener : this._listeners) {
            listener.newFolderButtonClicked();
        }
    }

    private void refreshButtonClicked() {
        for (FolderToolBarListener listener : this._listeners) {
            listener.refreshButtonClicked();
        }
    }

    private void myDocumentsButtonClicked() {
        for (FolderToolBarListener listener : this._listeners) {
            listener.myDocumentsButtonClicked();
        }
    }

    private void desktopButtonClicked() {
        for (FolderToolBarListener listener : this._listeners) {
            listener.desktopButtonClicked();
        }
    }

    private void recentFolderSelected(File recentFolder) {
        for (FolderToolBarListener listener : this._listeners) {
            listener.recentFolderSelected(recentFolder);
        }
    }

    public void setRecentList(List<String> recentFoldersList) {
        if (recentFoldersList != null) {
            this._recentFoldersList.setModel(new DefaultComboBoxModel<Object>(recentFoldersList.toArray()));
        }
    }

    static class NoFocusButton
    extends JButton {
        public NoFocusButton(Action a) {
            super(a);
            this.setRequestFocusEnabled(false);
            this.setFocusable(false);
            Insets margin = this.getMargin();
            margin.left = margin.top;
            margin.right = margin.bottom;
            this.setMargin(margin);
        }
    }

    private abstract class ToolBarAction
    extends AbstractAction {
        public ToolBarAction(String name, Icon icon) {
            super(name, icon);
        }
    }

    private class FileListCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer m_defaultRenderer = new DefaultListCellRenderer();

        private FileListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.m_defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File f = null;
            if (value instanceof File) {
                f = (File)value;
            } else if (value != null) {
                f = new File(value.toString());
            }
            if (f != null && f.exists()) {
                String text = _fsv.getSystemDisplayName(f);
                Icon icon = _fsv.getSystemIcon(f);
                renderer.setIcon(icon);
                renderer.setText(text);
                renderer.setToolTipText(f.getAbsolutePath());
            } else {
                String filePath = value == null ? "" : value.toString();
                renderer.setText(filePath);
                renderer.setToolTipText(filePath);
            }
            return renderer;
        }
    }
}

