/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public abstract class StandardDialogPane
extends JPanel
implements ButtonNames {
    private boolean _lazyConstructorCalled = false;
    protected JComponent _bannerPanel;
    protected JComponent _contentPanel;
    protected ButtonPanel _buttonPanel;
    private Action _defaultCancelAction;
    private Action _defaultAction;
    private Component _initFocusedComponent;
    public static final String PROPERTY_CANCEL_ACTION = "defaultCancelAction";
    public static final String PROPERTY_DEFAULT_ACTION = "defaultAction";

    public Action getDefaultCancelAction() {
        return this._defaultCancelAction;
    }

    public void setDefaultCancelAction(Action defaultCancelAction) {
        Action oldAction = this._defaultCancelAction;
        this._defaultCancelAction = defaultCancelAction;
        this.firePropertyChange(PROPERTY_CANCEL_ACTION, oldAction, this._defaultCancelAction);
    }

    public Action getDefaultAction() {
        return this._defaultAction;
    }

    public void setDefaultAction(Action defaultAction) {
        Action oldAction = this._defaultAction;
        this._defaultAction = defaultAction;
        this.firePropertyChange(PROPERTY_DEFAULT_ACTION, oldAction, this._defaultAction);
    }

    public void initComponents() {
        this._buttonPanel = this.createButtonPanel();
        this._bannerPanel = this.createBannerPanel();
        this._contentPanel = this.createContentPanel();
        this.layoutComponents(this._bannerPanel, this._contentPanel, this._buttonPanel);
        if (this.getRootPane() != null) {
            if (this.getRootPane().getDefaultButton() != null) {
                this.getRootPane().getDefaultButton().requestFocus();
            }
            if (this.getDefaultCancelAction() != null) {
                this.getRootPane().registerKeyboardAction(new DelegateAction(this.getDefaultCancelAction()){

                    public boolean delegateActionPerformed(ActionEvent e) {
                        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (selectedPath != null && selectedPath.length > 0) {
                            MenuSelectionManager.defaultManager().clearSelectedPath();
                            return true;
                        }
                        return false;
                    }
                }, KeyStroke.getKeyStroke(27, 0), 2);
            }
            if (this.getDefaultAction() != null) {
                this.getRootPane().registerKeyboardAction(this.getDefaultAction(), KeyStroke.getKeyStroke(10, 0), 1);
            }
        }
    }

    protected void layoutComponents(Component bannerPanel, Component contentPanel, ButtonPanel buttonPanel) {
        this.setLayout(new BorderLayout());
        if (bannerPanel != null) {
            this.add(bannerPanel, "First");
        }
        if (contentPanel != null) {
            this.add(contentPanel, "Center");
        }
        if (buttonPanel != null) {
            if (buttonPanel.getAlignment() == 1 || buttonPanel.getAlignment() == 3) {
                this.add((Component)buttonPanel, "After");
            } else {
                this.add((Component)buttonPanel, "Last");
            }
        }
    }

    public Component getInitFocusedComponent() {
        return this._initFocusedComponent;
    }

    public void setInitFocusedComponent(Component initFocusedComponent) {
        this._initFocusedComponent = initFocusedComponent;
    }

    public JComponent getBannerPanel() {
        return this._bannerPanel;
    }

    public JComponent getContentPanel() {
        return this._contentPanel;
    }

    public ButtonPanel getButtonPanel() {
        return this._buttonPanel;
    }

    public abstract JComponent createBannerPanel();

    public abstract JComponent createContentPanel();

    public abstract ButtonPanel createButtonPanel();
}

