/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.TreeIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class DialogPageTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Color _textSelectionColor = UIDefaultsLookup.getColor("Tree.selectionForeground");
    protected Color _textNonSelectionColor = UIDefaultsLookup.getColor("Tree.textForeground");
    protected Color _bkSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBackground");
    protected Color _bkNonSelectionColor = UIDefaultsLookup.getColor("Tree.textBackground");
    protected Color _borderSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBorderColor");
    protected boolean m_selected;
    private static final Icon SELECTED = TreeIconsFactory.getImageIcon("icons/selected-b16.gif");
    private static final Icon BLANK = TreeIconsFactory.getImageIcon("icons/blank-16.gif");

    public DialogPageTreeCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object obj = node.getUserObject();
        if (obj instanceof Boolean) {
            this.setText("Retrieving data...");
        }
        if (obj instanceof AbstractDialogPage) {
            AbstractDialogPage idata = (AbstractDialogPage)obj;
            this.setText(idata.getTitle());
        } else {
            this.setText(obj.toString());
            this.setIcon(null);
        }
        this.setFont(tree.getFont());
        this.setForeground(sel ? this._textSelectionColor : this._textNonSelectionColor);
        this.setBackground(sel ? this._bkSelectionColor : this._bkNonSelectionColor);
        if (leaf) {
            if (sel) {
                this.setIcon(SELECTED);
            } else {
                this.setIcon(BLANK);
            }
        } else if (expanded) {
            this.setIcon(UIDefaultsLookup.getIcon("Tree.openIcon"));
        } else {
            this.setIcon(UIDefaultsLookup.getIcon("Tree.closedIcon"));
        }
        this.m_selected = sel;
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return this;
    }

    public void paintComponent(Graphics g) {
        Color bColor = this.getBackground();
        Icon icon = this.getIcon();
        g.setColor(bColor);
        int offset = 0;
        if (icon != null && this.getText() != null) {
            offset = icon.getIconWidth() + this.getIconTextGap() - 1;
        }
        g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        if (this.m_selected) {
            g.setColor(this._borderSelectionColor);
            g.drawRect(offset, 0, this.getWidth() - offset - 1, this.getHeight() - 1);
        }
        super.paintComponent(g);
    }
}

