/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SizeRequirements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ButtonPanelLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private Container _target;
    private transient SizeRequirements[] _xChildren;
    private transient SizeRequirements[] _yChildren;
    private transient SizeRequirements _xTotal;
    private transient SizeRequirements _yTotal;
    private List<Component> _affirmativeButtons = new Vector<Component>(13);
    private List<Component> _cancelButtons = new Vector<Component>(13);
    private List<Component> _helpButtons = new Vector<Component>(13);
    private List<Component> _otherButtons = new Vector<Component>(13);
    int _minWidth;
    int _maxWidth;
    int _groupGap = 10;
    int _buttonGap = 6;
    private int _sizeConstraint = 1;
    private String _buttonOrder = "ACO";
    private String _oppositeButtonOrder = "H";
    private int _minButtonWidth = 75;
    private int _axis = 0;
    private int _alignment = 11;
    private static final long serialVersionUID = -738156624351781041L;

    public ButtonPanelLayout(Container target, int axis, int alignment, int sizeConstraint, String buttonOrder, String oppositeButtonOrder, int buttonGap, int groupGap) {
        if (axis != 0 && axis != 1 && axis != 2 && axis != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = axis;
        this._target = target;
        this._alignment = alignment;
        this._sizeConstraint = sizeConstraint;
        this._buttonOrder = buttonOrder;
        this._oppositeButtonOrder = oppositeButtonOrder;
        this._buttonGap = buttonGap;
        this._groupGap = groupGap;
    }

    @Override
    public synchronized void invalidateLayout(Container target) {
        this.checkContainer(target);
        this._xChildren = null;
        this._yChildren = null;
        this._xTotal = null;
        this._yTotal = null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this._affirmativeButtons.contains(comp)) {
            this._affirmativeButtons.remove(comp);
        }
        if (this._cancelButtons.contains(comp)) {
            this._cancelButtons.remove(comp);
        }
        if (this._helpButtons.contains(comp)) {
            this._helpButtons.remove(comp);
        }
        if (this._otherButtons.contains(comp)) {
            this._otherButtons.remove(comp);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if ("AFFIRMATIVE".equals(constraints) && !this._affirmativeButtons.contains(comp)) {
            this._affirmativeButtons.add(comp);
        }
        if ("CANCEL".equals(constraints) && !this._cancelButtons.contains(comp)) {
            this._cancelButtons.add(comp);
        }
        if ("HELP".equals(constraints) && !this._helpButtons.contains(comp)) {
            this._helpButtons.add(comp);
        }
        if ("ALTERNATIVE".equals(constraints) && !this._otherButtons.contains(comp)) {
            this._otherButtons.add(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension size;
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.preferred, this._yTotal.preferred);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension size;
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.minimum, this._yTotal.minimum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension size;
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.maximum, this._yTotal.maximum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this._xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this._yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        this.checkContainer(target);
        Dimension alloc = target.getSize();
        Insets in = target.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        ComponentOrientation o = target.getComponentOrientation();
        int absoluteAxis = this.resolveAxis(this._axis, o);
        boolean ltr = o.isLeftToRight();
        int alignment = this._alignment;
        if (this._alignment == 10) {
            alignment = ltr ? 2 : 4;
        } else if (this._alignment == 11) {
            alignment = ltr ? 4 : 2;
        }
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkRequests();
            this.resetBounds();
            if (absoluteAxis == 0) {
                int y = in.top;
                if (alignment == 0) {
                    char c;
                    int i;
                    Dimension size = this.preferredLayoutSize(target);
                    int x = (alloc.width + size.width) / 2;
                    for (i = 0; i < this.getButtonOrder().length(); ++i) {
                        c = this.getButtonOrder().charAt(this.getButtonOrder().length() - i - 1);
                        if (c == 'A' || c == 'a') {
                            x = this.layoutButtonsRightAlign(this._affirmativeButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            x = this.layoutButtonsRightAlign(this._cancelButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            x = this.layoutButtonsRightAlign(this._helpButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        x = this.layoutButtonsRightAlign(this._otherButtons, x, y, alloc, ltr);
                    }
                    x = (alloc.width - size.width) / 2;
                    for (i = 0; i < this.getOppositeButtonOrder().length(); ++i) {
                        c = this.getOppositeButtonOrder().charAt(i);
                        if (c == 'A' || c == 'a') {
                            x = this.layoutButtonsLeftAlign(this._affirmativeButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            x = this.layoutButtonsLeftAlign(this._cancelButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            x = this.layoutButtonsLeftAlign(this._helpButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        x = this.layoutButtonsLeftAlign(this._otherButtons, x, y, alloc, ltr);
                    }
                } else if (alignment == 4) {
                    char c;
                    int i;
                    int x = in.left + alloc.width;
                    for (i = 0; i < this.getButtonOrder().length(); ++i) {
                        c = this.getButtonOrder().charAt(ltr ? this.getButtonOrder().length() - i - 1 : i);
                        if (c == 'A' || c == 'a') {
                            x = this.layoutButtonsRightAlign(this._affirmativeButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            x = this.layoutButtonsRightAlign(this._cancelButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            x = this.layoutButtonsRightAlign(this._helpButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        x = this.layoutButtonsRightAlign(this._otherButtons, x, y, alloc, ltr);
                    }
                    x = in.left;
                    for (i = 0; i < this.getOppositeButtonOrder().length(); ++i) {
                        c = this.getOppositeButtonOrder().charAt(ltr ? i : this.getOppositeButtonOrder().length() - i - 1);
                        if (c == 'A' || c == 'a') {
                            x = this.layoutButtonsLeftAlign(this._affirmativeButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            x = this.layoutButtonsLeftAlign(this._cancelButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            x = this.layoutButtonsLeftAlign(this._helpButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        x = this.layoutButtonsLeftAlign(this._otherButtons, x, y, alloc, ltr);
                    }
                } else if (alignment == 2) {
                    char c;
                    int i;
                    int x = in.left;
                    for (i = 0; i < this.getButtonOrder().length(); ++i) {
                        c = this.getButtonOrder().charAt(ltr ? i : this.getButtonOrder().length() - i - 1);
                        if (c == 'A' || c == 'a') {
                            x = this.layoutButtonsLeftAlign(this._affirmativeButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            x = this.layoutButtonsLeftAlign(this._cancelButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            x = this.layoutButtonsLeftAlign(this._helpButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        x = this.layoutButtonsLeftAlign(this._otherButtons, x, y, alloc, ltr);
                    }
                    x = in.left + alloc.width;
                    for (i = 0; i < this.getOppositeButtonOrder().length(); ++i) {
                        c = this.getOppositeButtonOrder().charAt(ltr ? this.getOppositeButtonOrder().length() - i - 1 : i);
                        if (c == 'A' || c == 'a') {
                            x = this.layoutButtonsRightAlign(this._affirmativeButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            x = this.layoutButtonsRightAlign(this._cancelButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            x = this.layoutButtonsRightAlign(this._helpButtons, x, y, alloc, ltr);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        x = this.layoutButtonsRightAlign(this._otherButtons, x, y, alloc, ltr);
                    }
                }
            } else {
                int x = in.left;
                if (alignment == 1) {
                    char c;
                    int i;
                    int y = in.top;
                    for (i = 0; i < this.getButtonOrder().length(); ++i) {
                        c = this.getButtonOrder().charAt(i);
                        if (c == 'A' || c == 'a') {
                            y = this.layoutButtonsTopAlign(this._affirmativeButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            y = this.layoutButtonsTopAlign(this._cancelButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            y = this.layoutButtonsTopAlign(this._helpButtons, x, y, alloc);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        y = this.layoutButtonsTopAlign(this._otherButtons, x, y, alloc);
                    }
                    y = in.top + alloc.height;
                    for (i = 0; i < this.getOppositeButtonOrder().length(); ++i) {
                        c = this.getOppositeButtonOrder().charAt(this.getOppositeButtonOrder().length() - i - 1);
                        if (c == 'A' || c == 'a') {
                            y = this.layoutButtonsBottomAlign(this._affirmativeButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            y = this.layoutButtonsBottomAlign(this._cancelButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            y = this.layoutButtonsBottomAlign(this._helpButtons, x, y, alloc);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        y = this.layoutButtonsBottomAlign(this._otherButtons, x, y, alloc);
                    }
                } else if (alignment == 3) {
                    char c;
                    int i;
                    int y = in.top + alloc.height;
                    for (i = 0; i < this.getButtonOrder().length(); ++i) {
                        c = this.getButtonOrder().charAt(this.getButtonOrder().length() - i - 1);
                        if (c == 'A' || c == 'a') {
                            y = this.layoutButtonsBottomAlign(this._affirmativeButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            y = this.layoutButtonsBottomAlign(this._cancelButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            y = this.layoutButtonsBottomAlign(this._helpButtons, x, y, alloc);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        y = this.layoutButtonsBottomAlign(this._otherButtons, x, y, alloc);
                    }
                    y = in.top;
                    for (i = 0; i < this.getOppositeButtonOrder().length(); ++i) {
                        c = this.getOppositeButtonOrder().charAt(i);
                        if (c == 'A' || c == 'a') {
                            y = this.layoutButtonsTopAlign(this._affirmativeButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            y = this.layoutButtonsTopAlign(this._cancelButtons, x, y, alloc);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            y = this.layoutButtonsTopAlign(this._helpButtons, x, y, alloc);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        y = this.layoutButtonsTopAlign(this._otherButtons, x, y, alloc);
                    }
                }
            }
        }
    }

    private int layoutButtonsRightAlign(List buttons, int x, int y, Dimension alloc, boolean ltr) {
        boolean containsVisibleButton = false;
        for (int i = this._target.getComponentCount() - 1; i >= 0; --i) {
            Component component = ltr ? this._target.getComponent(i) : this._target.getComponent(this._target.getComponentCount() - 1 - i);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            if (containsVisibleButton) {
                x -= this._buttonGap;
            }
            containsVisibleButton = true;
            int prefWidth = component.getPreferredSize().width;
            int width = prefWidth > this._minWidth || this.shouldKeepPreferredWidth(component) ? prefWidth : this._minWidth;
            component.setBounds(x - width, y, width, alloc.height);
            x -= width;
        }
        if (buttons.size() != 0 && containsVisibleButton) {
            x -= this._groupGap;
        }
        return x;
    }

    private int layoutButtonsLeftAlign(List<Component> buttons, int x, int y, Dimension alloc, boolean ltr) {
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = ltr ? this._target.getComponent(i) : this._target.getComponent(this._target.getComponentCount() - 1 - i);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            boolean containsVisibleButton = true;
            int prefWidth = component.getPreferredSize().width;
            int width = prefWidth > this._minWidth || this.shouldKeepPreferredWidth(component) ? prefWidth : this._minWidth;
            component.setBounds(x, y, width, alloc.height);
            x += width;
            if (i == buttons.size() - 1 || !containsVisibleButton) continue;
            x += this._buttonGap;
        }
        if (buttons.size() != 0) {
            x += this._groupGap;
        }
        return x;
    }

    private int layoutButtonsBottomAlign(List<Component> buttons, int x, int y, Dimension alloc) {
        boolean containsVisibleButton = false;
        for (int i = this._target.getComponentCount() - 1; i >= 0; --i) {
            Component component = this._target.getComponent(i);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            containsVisibleButton = true;
            Dimension preferredSize = component.getPreferredSize();
            int height = preferredSize.height;
            int prefWidth = preferredSize.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? alloc.width - prefWidth + x : x, y - height, this.shouldKeepPreferredWidth(component) ? prefWidth : alloc.width, height);
            y -= height;
            if (i == 0) continue;
            y -= this._buttonGap;
        }
        if (buttons.size() != 0 && containsVisibleButton) {
            y -= this._groupGap;
        }
        return y;
    }

    private int layoutButtonsTopAlign(List<Component> buttons, int x, int y, Dimension alloc) {
        boolean containsVisibleButton = false;
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            containsVisibleButton = true;
            Dimension preferredSize = component.getPreferredSize();
            int height = preferredSize.height;
            int prefWidth = preferredSize.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? alloc.width - prefWidth + x : x, y, this.shouldKeepPreferredWidth(component) ? prefWidth : alloc.width, height);
            y += height;
            if (i == buttons.size() - 1) continue;
            y += this._buttonGap;
        }
        if (buttons.size() != 0 && containsVisibleButton) {
            y += this._groupGap;
        }
        return y;
    }

    private boolean shouldKeepPreferredWidth(Component component) {
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("keepPreferredWidth"));
    }

    void checkContainer(Container target) {
        if (this._target != target) {
            throw new AWTError("BorderPaneLayout can't be shared");
        }
        if (!(target instanceof ButtonPanel)) {
            throw new AWTError("Target is not a ButtonPanel");
        }
    }

    int getButtonCountof(List<Component> buttons) {
        int count = 0;
        for (Component button : buttons) {
            if (!button.isVisible()) continue;
            ++count;
        }
        return count;
    }

    void checkRequests() {
        int totalGroup = (this.getButtonCountof(this._affirmativeButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._otherButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._cancelButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._helpButtons) == 0 ? 0 : 1);
        int totalButtonCount = this.getButtonCountof(this._affirmativeButtons) + this.getButtonCountof(this._otherButtons) + this.getButtonCountof(this._cancelButtons) + this.getButtonCountof(this._helpButtons);
        if (this._xChildren == null || this._yChildren == null) {
            int componentCount;
            int visibleComponentCount = componentCount = this._target.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                if (this._target.getComponent(i).isVisible()) continue;
                --visibleComponentCount;
            }
            this._xChildren = new SizeRequirements[visibleComponentCount];
            this._yChildren = new SizeRequirements[visibleComponentCount];
            int index = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component c = this._target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension min = c.getMinimumSize();
                Dimension typ = c.getPreferredSize();
                Dimension max = c.getMaximumSize();
                this._xChildren[index] = new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX());
                this._yChildren[index] = new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY());
                if (this.shouldKeepPreferredWidth(this._target.getComponent(i))) {
                    this._xChildren[index].maximum = 0;
                }
                ++index;
            }
            int absoluteAxis = this.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (absoluteAxis == 0) {
                int width;
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getAlignedSizeRequirements(this._yChildren);
                this._maxWidth = SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._xChildren).maximum;
                if (this._sizeConstraint == 0) {
                    width = this.getMinButtonWidth();
                    if (this._maxWidth < width) {
                        this._maxWidth = width;
                    }
                    this._minWidth = this._maxWidth;
                } else {
                    width = this.getMinButtonWidth();
                    this._minWidth = width == 0 ? 75 : width;
                }
                for (SizeRequirements sizeRequirements : this._xChildren) {
                    if (sizeRequirements.preferred >= this._minWidth) continue;
                    sizeRequirements.preferred = this._minWidth;
                }
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._xTotal.preferred += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
                this._xTotal.minimum += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
            } else {
                this._xTotal = SizeRequirements.getAlignedSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getTiledSizeRequirements(this._yChildren);
                int width = this.getMinButtonWidth();
                this._maxWidth = width == 0 ? 75 : width;
                this._minWidth = this._maxWidth;
                this._xTotal.preferred = this._maxWidth > this._xTotal.maximum ? this._maxWidth : this._xTotal.preferred;
                this._yTotal.preferred += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
                this._yTotal.minimum += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
            }
        }
    }

    private int resolveAxis(int axis, ComponentOrientation o) {
        int absoluteAxis = axis == 2 ? (o.isHorizontal() ? 0 : 1) : (axis == 3 ? (o.isHorizontal() ? 1 : 0) : axis);
        return absoluteAxis;
    }

    public int getGroupGap() {
        return this._groupGap;
    }

    public void setGroupGap(int groupGap) {
        this._groupGap = groupGap;
        this.invalidateLayout(this._target);
    }

    public int getButtonGap() {
        return this._buttonGap;
    }

    public void setButtonGap(int buttonGap) {
        this._buttonGap = buttonGap;
        this.invalidateLayout(this._target);
    }

    public int getSizeConstraint() {
        return this._sizeConstraint;
    }

    public void setSizeConstraint(int sizeConstraint) {
        this._sizeConstraint = sizeConstraint;
        this.invalidateLayout(this._target);
    }

    public int getMinButtonWidth() {
        return this._minButtonWidth;
    }

    public void setMinButtonWidth(int minButtonWidth) {
        this._minButtonWidth = minButtonWidth;
        this.invalidateLayout(this._target);
    }

    public String getButtonOrder() {
        if (this._buttonOrder == null) {
            return "";
        }
        return this._buttonOrder;
    }

    public void setButtonOrder(String buttonOrder) {
        this._buttonOrder = buttonOrder;
        this.invalidateLayout(this._target);
    }

    public String getOppositeButtonOrder() {
        if (this._oppositeButtonOrder == null) {
            return "";
        }
        return this._oppositeButtonOrder;
    }

    public void setOppositeButtonOrder(String oppositeButtonOrder) {
        this._oppositeButtonOrder = oppositeButtonOrder;
        this.invalidateLayout(this._target);
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int axis) {
        this._axis = axis;
        this.invalidateLayout(this._target);
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
        this.invalidateLayout(this._target);
    }

    void resetBounds() {
        for (Component component : this._affirmativeButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._cancelButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._otherButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._helpButtons) {
            component.setBounds(0, 0, 0, 0);
        }
    }
}

