/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ArrayConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.awt.Color;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArrayConverter
extends ArrayConverter {
    public DefaultArrayConverter(String separator, Class<?> elementClass) {
        super(separator, -1, elementClass);
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            Object[] objects = this.getElementClass() == Object.class ? (Object[])object : new Object[Array.getLength(object)];
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = Array.get(object, i);
            }
            return this.arrayToString(objects, context);
        }
        return ObjectConverterManager.toString(object, this.getElementClass(), context);
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        if (string == null || "".equals(string)) {
            return new Object[0];
        }
        Object[] objects = this.arrayFromString(string, context);
        Class<?> elementClass = this.getElementClass();
        if (elementClass == Object.class) {
            return objects;
        }
        for (Object object : objects) {
            if (elementClass.isAssignableFrom(object.getClass())) continue;
            return new Object[0];
        }
        Object array = Array.newInstance(elementClass, objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            Array.set(array, i, object);
        }
        return array;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public static void main(String[] args) {
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).toString(new int[]{2, 3, 2, 4}, null));
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).fromString("2;3;2;4", null));
        System.out.println(new DefaultArrayConverter(";", Color.class).toString(new Color[]{Color.RED, Color.YELLOW, Color.GREEN}, HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Color.class).fromString("#FF0000;#FFFF00;#00FF00", HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Object.class).fromString("#FF0000;#FFFF00;#00FF00", null));
    }
}

