/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.util.Locale;

public class BooleanConverter
implements ObjectConverter {
    public String toString(Object object, ConverterContext context) {
        if (Boolean.FALSE.equals(object)) {
            return this.getFalse();
        }
        if (Boolean.TRUE.equals(object)) {
            return this.getTrue();
        }
        return "";
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public Object fromString(String string, ConverterContext context) {
        if (string.equalsIgnoreCase(this.getTrue())) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase(this.getFalse())) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    private String getTrue() {
        String s = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.true");
        return s != null ? s.trim() : s;
    }

    private String getFalse() {
        String s = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.false");
        return s != null ? s.trim() : s;
    }
}

